/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.callback;

import com.fasterxml.jackson.databind.JsonNode;
import io.smallrye.openapi.api.models.callbacks.CallbackImpl;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.callback.CallbackConstant;
import io.smallrye.openapi.runtime.io.extension.ExtensionConstant;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.io.paths.PathsReader;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.MethodInfo;

public class CallbackReader {
    private CallbackReader() {
    }

    public static Map<String, Callback> readCallbacks(AnnotationScannerContext context, AnnotationValue annotationValue) {
        AnnotationInstance[] nestedArray;
        if (annotationValue == null) {
            return null;
        }
        IoLogging.logger.annotationsMap("@Callback");
        LinkedHashMap<String, Callback> callbacks = new LinkedHashMap<String, Callback>();
        for (AnnotationInstance nested : nestedArray = annotationValue.asNestedArray()) {
            String name = CallbackReader.getCallbackName(nested);
            if (name == null && JandexUtil.isRef(nested)) {
                name = JandexUtil.nameFromRef(nested);
            }
            if (name == null) continue;
            callbacks.put(name, CallbackReader.readCallback(context, nested));
        }
        return callbacks;
    }

    public static Map<String, Callback> readCallbacks(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        IoLogging.logger.jsonNodeMap("Callback");
        LinkedHashMap<String, Callback> callbacks = new LinkedHashMap<String, Callback>();
        Iterator<String> fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = fieldNames.next();
            JsonNode childNode = node.get(fieldName);
            callbacks.put(fieldName, CallbackReader.readCallback(childNode));
        }
        return callbacks;
    }

    public static Callback readCallback(AnnotationScannerContext context, AnnotationInstance annotation) {
        return CallbackReader.readCallback(context, annotation, null);
    }

    public static Callback readCallback(AnnotationScannerContext context, AnnotationInstance annotation, MethodInfo methodInfo) {
        if (annotation == null) {
            return null;
        }
        IoLogging.logger.singleAnnotation("@Callback");
        CallbackImpl callback = new CallbackImpl();
        callback.setRef(JandexUtil.refValue(annotation, JandexUtil.RefType.CALLBACK));
        String expression = JandexUtil.stringValue(annotation, "callbackUrlExpression");
        callback.addPathItem(expression, PathsReader.readPathItem(context, annotation.value("operations"), null));
        callback.setExtensions(ExtensionReader.readExtensions(context, annotation));
        return callback;
    }

    private static Callback readCallback(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        IoLogging.logger.singleJsonNode("Callback");
        CallbackImpl callback = new CallbackImpl();
        callback.setRef(JsonUtil.stringProperty(node, "$ref"));
        Iterator<String> fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = fieldNames.next();
            if (ExtensionConstant.isExtensionField(fieldName) || fieldName.equals("$ref")) continue;
            callback.addPathItem(fieldName, PathsReader.readPathItem(node.get(fieldName)));
        }
        ExtensionReader.readExtensions(node, callback);
        return callback;
    }

    public static List<AnnotationInstance> getCallbackAnnotations(AnnotationTarget target) {
        return JandexUtil.getRepeatableAnnotation(target, CallbackConstant.DOTNAME_CALLBACK, CallbackConstant.DOTNAME_CALLBACKS);
    }

    public static String getCallbackName(AnnotationInstance annotation) {
        return JandexUtil.stringValue(annotation, "name");
    }
}

