/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.impl;

import io.smallrye.mutiny.Multi;
import io.smallrye.reactive.messaging.ChannelRegistar;
import io.smallrye.reactive.messaging.ChannelRegistry;
import io.smallrye.reactive.messaging.connector.InboundConnector;
import io.smallrye.reactive.messaging.connector.OutboundConnector;
import io.smallrye.reactive.messaging.providers.PublisherDecorator;
import io.smallrye.reactive.messaging.providers.i18n.ProviderExceptions;
import io.smallrye.reactive.messaging.providers.i18n.ProviderLogging;
import io.smallrye.reactive.messaging.providers.impl.ConnectorConfig;
import io.smallrye.reactive.messaging.providers.impl.ConnectorFactories;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

@ApplicationScoped
public class ConfiguredChannelFactory
implements ChannelRegistar {
    protected final Config config;
    protected final ChannelRegistry registry;
    private final ConnectorFactories factories;
    @Inject
    private Instance<PublisherDecorator> publisherDecoratorInstance;

    protected ConfiguredChannelFactory() {
        this.config = null;
        this.registry = null;
        this.factories = null;
    }

    @Inject
    public ConfiguredChannelFactory(ConnectorFactories factories, Instance<Config> config, @Any Instance<ChannelRegistry> registry) {
        this(factories, config, registry, true);
    }

    ConfiguredChannelFactory(ConnectorFactories factories, Instance<Config> config, @Any Instance<ChannelRegistry> registry, boolean logConnectors) {
        this.registry = (ChannelRegistry)registry.get();
        this.factories = factories;
        if (config.isUnsatisfied()) {
            this.config = null;
        } else {
            if (logConnectors) {
                ProviderLogging.log.foundIncomingConnectors(factories.getInboundConnectors().keySet());
                ProviderLogging.log.foundOutgoingConnectors(factories.getOutboundConnectors().keySet());
            }
            this.config = config.stream().findFirst().orElseThrow(ProviderExceptions.ex::illegalStateRetrieveConfig);
        }
    }

    static Map<String, ConnectorConfig> extractConfigurationFor(String prefix, Config root) {
        Iterable<String> names = root.getPropertyNames();
        HashMap<String, ConnectorConfig> configs = new HashMap<String, ConnectorConfig>();
        names.forEach(key -> {
            if (key.startsWith(prefix)) {
                String name = key.substring(prefix.length());
                if (name.charAt(0) == '\"') {
                    name = name.substring(1, name.lastIndexOf(34));
                } else if (name.contains(".")) {
                    String tmp = name;
                    name = tmp.substring(0, tmp.indexOf(46));
                }
                configs.put(name, new ConnectorConfig(prefix, root, name));
            }
        });
        return configs;
    }

    @Override
    public void initialize() {
        if (this.config == null) {
            ProviderLogging.log.skippingMPConfig();
            return;
        }
        ProviderLogging.log.channelManagerInitializing();
        Map<String, ConnectorConfig> sourceConfiguration = ConfiguredChannelFactory.extractConfigurationFor("mp.messaging.incoming.", this.config);
        Map<String, ConnectorConfig> sinkConfiguration = ConfiguredChannelFactory.extractConfigurationFor("mp.messaging.outgoing.", this.config);
        this.detectNameConflict(sourceConfiguration, sinkConfiguration);
        this.register(sourceConfiguration, sinkConfiguration);
    }

    private void detectNameConflict(Map<String, ConnectorConfig> sourceConfiguration, Map<String, ConnectorConfig> sinkConfiguration) {
        HashSet<String> sources = new HashSet<String>(sourceConfiguration.keySet());
        Set<String> sinks = sinkConfiguration.keySet();
        sources.retainAll(sinks);
        if (!sources.isEmpty()) {
            throw ProviderExceptions.ex.deploymentInvalidConfiguration(sources);
        }
    }

    void register(Map<String, ConnectorConfig> sourceConfiguration, Map<String, ConnectorConfig> sinkConfiguration) {
        try {
            ConnectorConfig config;
            String channel;
            for (Map.Entry<String, ConnectorConfig> entry : sourceConfiguration.entrySet()) {
                channel = entry.getKey();
                config = entry.getValue();
                if (config.getOptionalValue("enabled", Boolean.TYPE).orElse(true).booleanValue()) {
                    this.registry.register(channel, this.createPublisher(channel, config), (boolean)config.getOptionalValue("broadcast", Boolean.class).orElse(false));
                    continue;
                }
                ProviderLogging.log.incomingChannelDisabled(channel);
            }
            for (Map.Entry<String, ConnectorConfig> entry : sinkConfiguration.entrySet()) {
                channel = entry.getKey();
                config = entry.getValue();
                if (config.getOptionalValue("enabled", Boolean.TYPE).orElse(true).booleanValue()) {
                    this.registry.register(channel, this.createSubscriber(channel, config), (boolean)config.getOptionalValue("merge", Boolean.class).orElse(false));
                    continue;
                }
                ProviderLogging.log.outgoingChannelDisabled(channel);
            }
        }
        catch (RuntimeException e) {
            ProviderLogging.log.unableToCreatePublisherOrSubscriber(e);
            throw e;
        }
    }

    private static String getConnectorAttribute(Config config) {
        return config.getValue("connector", String.class);
    }

    private Publisher<? extends Message<?>> createPublisher(String name, Config config) {
        String connector = ConfiguredChannelFactory.getConnectorAttribute(config);
        InboundConnector inboundConnector = this.factories.getInboundConnectors().get(connector);
        if (inboundConnector == null) {
            throw ProviderExceptions.ex.illegalArgumentUnknownConnector(name);
        }
        Publisher<? extends Message<?>> publisher = inboundConnector.getPublisher(config);
        for (PublisherDecorator decorator : this.publisherDecoratorInstance) {
            publisher = decorator.decorate(Multi.createFrom().publisher(publisher), name);
        }
        return publisher;
    }

    private Subscriber<? extends Message<?>> createSubscriber(String name, Config config) {
        String connector = ConfiguredChannelFactory.getConnectorAttribute(config);
        OutboundConnector outboundConnector = this.factories.getOutboundConnectors().get(connector);
        if (outboundConnector == null) {
            throw ProviderExceptions.ex.illegalArgumentUnknownConnector(name);
        }
        return outboundConnector.getSubscriber(config);
    }
}

