/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.common.handlers;

import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.kie.kogito.explainability.api.BaseExplainabilityResult;
import org.kie.kogito.trusty.service.common.handlers.ExplainerServiceHandler;

@ApplicationScoped
public class ExplainerServiceHandlerRegistry {
    private Instance<ExplainerServiceHandler<?>> explanationHandlers;

    protected ExplainerServiceHandlerRegistry() {
    }

    @Inject
    public ExplainerServiceHandlerRegistry(@Any Instance<ExplainerServiceHandler<?>> explanationHandlers) {
        this.explanationHandlers = explanationHandlers;
    }

    public <T extends BaseExplainabilityResult> T getExplainabilityResultById(String executionId, Class<T> type) {
        ExplainerServiceHandler<?> explanationHandler = this.getLocalExplainer(type).orElseThrow(() -> new IllegalArgumentException(String.format("Explainability result for '%s' is not supported", type.getName())));
        return this.cast((BaseExplainabilityResult)explanationHandler.getExplainabilityResultById(executionId));
    }

    public <T extends BaseExplainabilityResult> void storeExplainabilityResult(String executionId, T result) {
        Object type = this.cast(result);
        ExplainerServiceHandler<?> explanationHandler = this.getLocalExplainer(type.getClass()).orElseThrow(() -> new IllegalArgumentException(String.format("Explainability result for '%s' is not supported", type.getClass().getName())));
        explanationHandler.storeExplainabilityResult(executionId, this.cast(result));
    }

    private <T extends BaseExplainabilityResult> Optional<ExplainerServiceHandler<?>> getLocalExplainer(Class<T> type) {
        return this.explanationHandlers.stream().filter(handler -> handler.supports(type)).findFirst();
    }

    private <T extends BaseExplainabilityResult> T cast(BaseExplainabilityResult type) {
        return (T)type;
    }
}

