/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.common.handlers;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.kogito.explainability.api.LIMEExplainabilityResult;
import org.kie.kogito.explainability.api.SaliencyModel;
import org.kie.kogito.trusty.service.common.TrustyService;
import org.kie.kogito.trusty.service.common.responses.SalienciesResponse;
import org.kie.kogito.trusty.service.common.responses.SaliencyResponse;
import org.kie.kogito.trusty.storage.api.model.Decision;
import org.kie.kogito.trusty.storage.api.model.DecisionOutcome;

@ApplicationScoped
public class LIMESaliencyConverter {
    protected TrustyService trustyService;

    protected LIMESaliencyConverter() {
    }

    @Inject
    public LIMESaliencyConverter(TrustyService trustyService) {
        this.trustyService = trustyService;
    }

    public SalienciesResponse fromResult(String executionId, LIMEExplainabilityResult result) {
        return this.buildSalienciesResponse(this.trustyService.getDecisionById(executionId), result);
    }

    private SalienciesResponse buildSalienciesResponse(Decision decision, LIMEExplainabilityResult result) {
        Map outcomeNameToIdMap = decision == null ? Collections.emptyMap() : decision.getOutcomes().stream().collect(Collectors.toUnmodifiableMap(DecisionOutcome::getOutcomeName, DecisionOutcome::getOutcomeId));
        List<SaliencyResponse> saliencies = result.getSaliencies() == null ? Collections.emptyList() : result.getSaliencies().stream().map(saliency -> this.saliencyFrom((String)outcomeNameToIdMap.get(saliency.getOutcomeName()), (SaliencyModel)saliency)).filter(Objects::nonNull).collect(Collectors.toList());
        return new SalienciesResponse(result.getStatus().name(), result.getStatusDetails(), saliencies);
    }

    private SaliencyResponse saliencyFrom(String outcomeId, SaliencyModel saliency) {
        if (Objects.isNull(outcomeId)) {
            return null;
        }
        if (Objects.isNull(saliency)) {
            return null;
        }
        return new SaliencyResponse(outcomeId, saliency.getOutcomeName(), saliency.getFeatureImportance());
    }
}

