/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.health;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.health.AsyncHealthCheckFactory;
import io.smallrye.health.HealthLogging;
import io.smallrye.health.SmallRyeHealth;
import io.smallrye.health.api.AsyncHealthCheck;
import io.smallrye.health.api.HealthGroup;
import io.smallrye.health.api.Wellness;
import io.smallrye.health.registry.AbstractHealthRegistry;
import io.smallrye.health.registry.LivenessHealthRegistry;
import io.smallrye.health.registry.ReadinessHealthRegistry;
import io.smallrye.mutiny.Uni;
import java.io.OutputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import javax.json.spi.JsonProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.health.Health;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;

@ApplicationScoped
public class SmallRyeHealthReporter {
    private static final Map<String, ?> JSON_CONFIG = Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true);
    @Inject
    @Health
    Instance<HealthCheck> healthChecks;
    @Inject
    @Liveness
    Instance<HealthCheck> livenessChecks;
    @Inject
    @Readiness
    Instance<HealthCheck> readinessChecks;
    @Inject
    @Wellness
    Instance<HealthCheck> wellnessChecks;
    @Inject
    @Any
    Instance<HealthCheck> allHealthChecks;
    @Inject
    @Health
    Instance<AsyncHealthCheck> asyncHealthChecks;
    @Inject
    @Liveness
    Instance<AsyncHealthCheck> asyncLivenessChecks;
    @Inject
    @Readiness
    Instance<AsyncHealthCheck> asyncReadinessChecks;
    @Inject
    @Wellness
    Instance<AsyncHealthCheck> asyncWellnessChecks;
    @Inject
    @Any
    Instance<AsyncHealthCheck> allAsyncHealthChecks;
    @Inject
    BeanManager beanManager;
    @Inject
    @Liveness
    LivenessHealthRegistry livenessHealthRegistry;
    @Inject
    @Readiness
    ReadinessHealthRegistry readinessHealthRegistry;
    @Inject
    @ConfigProperty(name="io.smallrye.health.emptyChecksOutcome", defaultValue="UP")
    String emptyChecksOutcome;
    @Inject
    @ConfigProperty(name="io.smallrye.health.timeout.seconds", defaultValue="60")
    int timeoutSeconds;
    @Inject
    AsyncHealthCheckFactory asyncHealthCheckFactory;
    private final Map<String, Uni<HealthCheckResponse>> additionalChecks = new HashMap<String, Uni<HealthCheckResponse>>();
    private final JsonProvider jsonProvider = JsonProvider.provider();
    private Uni<SmallRyeHealth> smallRyeHealthUni = null;
    private Uni<SmallRyeHealth> smallRyeLivenessUni = null;
    private Uni<SmallRyeHealth> smallRyeReadinessUni = null;
    private Uni<SmallRyeHealth> smallryeWellnessUni = null;
    private boolean additionalListsChanged = false;
    private List<Uni<HealthCheckResponse>> healthUnis = new ArrayList<Uni<HealthCheckResponse>>();
    private List<Uni<HealthCheckResponse>> livenessUnis = new ArrayList<Uni<HealthCheckResponse>>();
    private List<Uni<HealthCheckResponse>> readinessUnis = new ArrayList<Uni<HealthCheckResponse>>();
    private List<Uni<HealthCheckResponse>> wellnessUnis = new ArrayList<Uni<HealthCheckResponse>>();

    @PostConstruct
    public void initChecks() {
        this.initUnis(this.healthUnis, this.healthChecks, this.asyncHealthChecks);
        this.initUnis(this.livenessUnis, this.livenessChecks, this.asyncLivenessChecks, this.livenessHealthRegistry);
        this.initUnis(this.readinessUnis, this.readinessChecks, this.asyncReadinessChecks, this.readinessHealthRegistry);
        this.initUnis(this.wellnessUnis, this.wellnessChecks, this.asyncWellnessChecks);
    }

    private void initUnis(List<Uni<HealthCheckResponse>> list, Iterable<HealthCheck> checks, Iterable<AsyncHealthCheck> asyncChecks) {
        this.initUnis(list, checks, asyncChecks, null);
    }

    private void initUnis(List<Uni<HealthCheckResponse>> list, Iterable<HealthCheck> checks, Iterable<AsyncHealthCheck> asyncChecks, AbstractHealthRegistry registry) {
        for (HealthCheck check : checks) {
            list.add(this.asyncHealthCheckFactory.callSync(check));
        }
        for (AsyncHealthCheck asyncCheck : asyncChecks) {
            list.add(this.asyncHealthCheckFactory.callAsync(asyncCheck));
        }
        if (registry != null) {
            list.addAll(registry.getChecks());
        }
    }

    void setEmptyChecksOutcome(String emptyChecksOutcome) {
        if (emptyChecksOutcome != null) {
            this.emptyChecksOutcome = emptyChecksOutcome;
        }
    }

    public void reportHealth(OutputStream out, SmallRyeHealth health) {
        if (health.isDown() && HealthLogging.log.isInfoEnabled()) {
            HealthLogging.log.healthDownStatus(health.getPayload().toString());
        }
        JsonWriterFactory factory = this.jsonProvider.createWriterFactory(JSON_CONFIG);
        JsonWriter writer = factory.createWriter(out);
        writer.writeObject(health.getPayload());
        writer.close();
    }

    public SmallRyeHealth getHealth() {
        return this.getHealth(this.smallRyeHealthUni, HealthType.HEALTH, HealthType.LIVENESS, HealthType.READINESS, HealthType.WELLNESS);
    }

    public SmallRyeHealth getLiveness() {
        return this.getHealth(this.smallRyeLivenessUni, HealthType.LIVENESS);
    }

    public SmallRyeHealth getReadiness() {
        return this.getHealth(this.smallRyeReadinessUni, HealthType.READINESS);
    }

    @Experimental(value="Wellness experimental checks")
    public SmallRyeHealth getWellness() {
        return this.getHealth(this.smallryeWellnessUni, HealthType.WELLNESS);
    }

    public SmallRyeHealth getHealthGroup(String groupName) {
        return this.getHealthGroupAsync(groupName).await().atMost(Duration.ofSeconds(this.timeoutSeconds));
    }

    public SmallRyeHealth getHealthGroups() {
        return this.getHealthGroupsAsync().await().atMost(Duration.ofSeconds(this.timeoutSeconds));
    }

    @Experimental(value="Asynchronous Health Check procedures")
    public Uni<SmallRyeHealth> getHealthAsync() {
        return this.getHealthAsync(this.smallRyeHealthUni, HealthType.HEALTH, HealthType.LIVENESS, HealthType.READINESS, HealthType.WELLNESS);
    }

    @Experimental(value="Asynchronous Health Check procedures")
    public Uni<SmallRyeHealth> getLivenessAsync() {
        return this.getHealthAsync(this.smallRyeLivenessUni, HealthType.LIVENESS);
    }

    @Experimental(value="Asynchronous Health Check procedures")
    public Uni<SmallRyeHealth> getReadinessAsync() {
        return this.getHealthAsync(this.smallRyeReadinessUni, HealthType.READINESS);
    }

    @Experimental(value="Asynchronous Health Check procedures & wellness experimental checks")
    public Uni<SmallRyeHealth> getWellnessAsync() {
        return this.getHealthAsync(this.smallryeWellnessUni, HealthType.WELLNESS);
    }

    @Experimental(value="Asynchronous Health Check procedures and Health Groups")
    public Uni<SmallRyeHealth> getHealthGroupAsync(String groupName) {
        ArrayList<Uni<HealthCheckResponse>> checks = new ArrayList<Uni<HealthCheckResponse>>();
        this.initUnis(checks, this.allHealthChecks.select(HealthGroup.Literal.of(groupName)), this.allAsyncHealthChecks.select(HealthGroup.Literal.of(groupName)));
        return this.getHealthAsync(checks);
    }

    @Experimental(value="Asynchronous Health Check procedures and Health Groups")
    public Uni<SmallRyeHealth> getHealthGroupsAsync() {
        ArrayList<Uni<HealthCheckResponse>> checks = new ArrayList<Uni<HealthCheckResponse>>();
        this.initUnis(checks, this.getHealthGroupsChecks(HealthCheck.class), this.getHealthGroupsChecks(AsyncHealthCheck.class));
        return this.getHealthAsync(checks);
    }

    private <T> List<T> getHealthGroupsChecks(Class<T> checkClass) {
        Iterator<Bean<?>> iterator = this.beanManager.getBeans(checkClass, Any.Literal.INSTANCE).iterator();
        ArrayList<Object> groupHealthChecks = new ArrayList<Object>();
        while (iterator.hasNext()) {
            Bean<?> bean = iterator.next();
            if (!bean.getQualifiers().stream().anyMatch(annotation -> annotation.annotationType().equals(HealthGroup.class))) continue;
            groupHealthChecks.add(this.beanManager.getReference(bean, bean.getBeanClass(), this.beanManager.createCreationalContext(bean)));
        }
        return groupHealthChecks;
    }

    private SmallRyeHealth getHealth(Uni<SmallRyeHealth> cachedHealth, HealthType ... types) {
        return this.getHealthAsync(cachedHealth, types).await().atMost(Duration.ofSeconds(this.timeoutSeconds));
    }

    private Uni<SmallRyeHealth> getHealthAsync(Uni<SmallRyeHealth> cachedHealth, HealthType ... types) {
        if (cachedHealth == null || this.additionalListsChanged(types)) {
            this.additionalListsChanged = false;
            cachedHealth = this.computeHealth(types);
        }
        return cachedHealth;
    }

    private boolean additionalListsChanged(HealthType ... types) {
        boolean needRecompute = false;
        block4: for (HealthType type : types) {
            switch (type) {
                case LIVENESS: {
                    if (!this.livenessHealthRegistry.checksChanged()) continue block4;
                    needRecompute = true;
                    continue block4;
                }
                case READINESS: {
                    if (!this.readinessHealthRegistry.checksChanged()) continue block4;
                    needRecompute = true;
                }
            }
        }
        return needRecompute;
    }

    private Uni<SmallRyeHealth> computeHealth(HealthType[] types) {
        ArrayList<Uni<HealthCheckResponse>> checks = new ArrayList<Uni<HealthCheckResponse>>();
        block6: for (HealthType type : types) {
            switch (type) {
                case HEALTH: {
                    checks.addAll(this.healthUnis);
                    continue block6;
                }
                case LIVENESS: {
                    checks.addAll(this.livenessUnis);
                    checks.addAll(this.livenessHealthRegistry.getChecks());
                    continue block6;
                }
                case READINESS: {
                    checks.addAll(this.readinessUnis);
                    checks.addAll(this.readinessHealthRegistry.getChecks());
                    continue block6;
                }
                case WELLNESS: {
                    checks.addAll(this.wellnessUnis);
                }
            }
        }
        return this.getHealthAsync(checks);
    }

    private Uni<SmallRyeHealth> getHealthAsync(Collection<Uni<HealthCheckResponse>> checks) {
        ArrayList<Uni<HealthCheckResponse>> healthCheckUnis = new ArrayList<Uni<HealthCheckResponse>>();
        if (checks != null) {
            healthCheckUnis.addAll(checks);
        }
        if (!this.additionalChecks.isEmpty()) {
            healthCheckUnis.addAll(this.additionalChecks.values());
        }
        if (healthCheckUnis.isEmpty()) {
            return Uni.createFrom().item(this.createEmptySmallRyeHealth());
        }
        return Uni.combine().all().unis(healthCheckUnis).combinedWith(responses -> {
            JsonArrayBuilder results = this.jsonProvider.createArrayBuilder();
            HealthCheckResponse.State status = HealthCheckResponse.State.UP;
            for (Object o : responses) {
                HealthCheckResponse response = (HealthCheckResponse)o;
                status = this.handleResponse(response, results, status);
            }
            return this.createSmallRyeHealth(results, status);
        });
    }

    private SmallRyeHealth createEmptySmallRyeHealth() {
        return this.createSmallRyeHealth(this.jsonProvider.createArrayBuilder(), null);
    }

    private SmallRyeHealth createSmallRyeHealth(JsonArrayBuilder results, HealthCheckResponse.State status) {
        JsonObjectBuilder builder = this.jsonProvider.createObjectBuilder();
        JsonArray checkResults = results.build();
        builder.add("status", checkResults.isEmpty() ? this.emptyChecksOutcome : status.toString());
        builder.add("checks", checkResults);
        return new SmallRyeHealth(builder.build());
    }

    private HealthCheckResponse.State handleResponse(HealthCheckResponse response, JsonArrayBuilder results, HealthCheckResponse.State globalOutcome) {
        String status;
        JsonObject responseJson = this.jsonObject(response);
        results.add(responseJson);
        if (globalOutcome == HealthCheckResponse.State.UP && (status = responseJson.getString("status")).equals("DOWN")) {
            return HealthCheckResponse.State.DOWN;
        }
        return globalOutcome;
    }

    private JsonObject jsonObject(HealthCheckResponse response) {
        JsonObjectBuilder builder = this.jsonProvider.createObjectBuilder();
        builder.add("name", response.getName());
        builder.add("status", response.getState().toString());
        response.getData().ifPresent(d -> {
            JsonObjectBuilder data = this.jsonProvider.createObjectBuilder();
            for (Map.Entry entry : d.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof String) {
                    data.add((String)entry.getKey(), (String)value);
                    continue;
                }
                if (value instanceof Long) {
                    data.add((String)entry.getKey(), (Long)value);
                    continue;
                }
                if (!(value instanceof Boolean)) continue;
                data.add((String)entry.getKey(), (Boolean)value);
            }
            builder.add("data", data.build());
        });
        return builder.build();
    }

    public void addHealthCheck(HealthCheck check) {
        if (check != null) {
            this.additionalChecks.put(check.getClass().getName(), this.asyncHealthCheckFactory.callSync(check));
            this.additionalListsChanged = true;
        }
    }

    public void addHealthCheck(AsyncHealthCheck check) {
        if (check != null) {
            this.additionalChecks.put(check.getClass().getName(), this.asyncHealthCheckFactory.callAsync(check));
            this.additionalListsChanged = true;
        }
    }

    public void removeHealthCheck(HealthCheck check) {
        this.additionalChecks.remove(check.getClass().getName());
        this.additionalListsChanged = true;
    }

    public void removeHealthCheck(AsyncHealthCheck check) {
        this.additionalChecks.remove(check.getClass().getName());
        this.additionalListsChanged = true;
    }

    static enum HealthType {
        HEALTH,
        LIVENESS,
        READINESS,
        WELLNESS;

    }
}

