/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.streams.stages;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.streams.Engine;
import io.smallrye.mutiny.streams.operators.TerminalStage;
import io.smallrye.mutiny.streams.operators.TerminalStageFactory;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collector;
import org.eclipse.microprofile.reactive.streams.operators.spi.Stage;

public class CollectStageFactory
implements TerminalStageFactory<Stage.Collect> {
    @Override
    public <I, O> TerminalStage<I, O> create(Engine engine, Stage.Collect stage) {
        Collector<?, ?, ?> collector = Objects.requireNonNull(stage).getCollector();
        Objects.requireNonNull(collector);
        return new CollectStage(collector);
    }

    private static class CollectStage<I, O>
    implements TerminalStage<I, O> {
        private final Collector<I, Object, O> collector;

        CollectStage(Collector<I, Object, O> collector) {
            this.collector = collector;
        }

        @Override
        public CompletionStage<O> apply(Multi<I> source) {
            return source.collectItems().with(this.collector).subscribeAsCompletionStage();
        }
    }
}

