/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.runtime;

import io.quarkus.arc.DefaultBean;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.StreamSupport;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.inject.Named;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@Dependent
public class KafkaRuntimeConfigProducer {
    private String configPrefix = "kafka";

    @Produces
    @DefaultBean
    @ApplicationScoped
    @Named(value="default-kafka-broker")
    public Map<String, Object> createKafkaRuntimeConfig() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Config config = ConfigProvider.getConfig();
        StreamSupport.stream(config.getPropertyNames().spliterator(), false).map(String::toLowerCase).filter(name -> name.startsWith(this.configPrefix)).distinct().sorted().forEach(name -> {
            String key = name.substring(this.configPrefix.length() + 1).toLowerCase().replaceAll("[^a-z0-9.]", ".");
            String value = config.getOptionalValue((String)name, String.class).orElse("");
            properties.put(key, value);
        });
        return properties;
    }
}

