/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.redis;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.StorageService;
import org.kie.kogito.persistence.api.factory.StorageQualifier;
import org.kie.kogito.persistence.redis.RedisClientManager;
import org.kie.kogito.persistence.redis.RedisStorage;
import org.kie.kogito.persistence.redis.index.RedisIndexManager;

@ApplicationScoped
@StorageQualifier(value="redis")
public class RedisCacheManager
implements StorageService {
    @Inject
    RedisClientManager redisClientManager;
    @Inject
    RedisIndexManager redisIndexManager;

    @Override
    public Storage<String, String> getCache(String name) {
        return new RedisStorage<String>(this.redisClientManager.getClient(name), this.redisIndexManager, name, String.class);
    }

    @Override
    public <T> Storage<String, T> getCache(String name, Class<T> type) {
        return new RedisStorage<T>(this.redisClientManager.getClient(name), this.redisIndexManager, name, type);
    }

    @Override
    public <T> Storage<String, T> getCache(String name, Class<T> type, String rootType) {
        return new RedisStorage<T>(this.redisClientManager.getClient(name), this.redisIndexManager, name, type);
    }
}

