/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.common.messaging.incoming;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.decision.DecisionModelMetadata;
import org.kie.kogito.tracing.decision.event.model.ModelEvent;
import org.kie.kogito.trusty.service.common.TrustyService;
import org.kie.kogito.trusty.service.common.messaging.BaseEventConsumer;
import org.kie.kogito.trusty.service.common.messaging.incoming.ModelIdentifier;
import org.kie.kogito.trusty.storage.api.model.DMNModelWithMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ModelEventConsumer
extends BaseEventConsumer<ModelEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(ModelEventConsumer.class);
    private static final TypeReference<ModelEvent> CLOUD_EVENT_TYPE = new TypeReference<ModelEvent>(){};

    ModelEventConsumer() {
    }

    @Inject
    public ModelEventConsumer(TrustyService service, ObjectMapper mapper) {
        super(service, mapper);
    }

    @Override
    @Incoming(value="kogito-tracing-model")
    public CompletionStage<Void> handleMessage(Message<String> message) {
        return super.handleMessage(message);
    }

    @Override
    protected TypeReference<ModelEvent> getEventType() {
        return CLOUD_EVENT_TYPE;
    }

    @Override
    protected void internalHandleCloudEvent(CloudEvent cloudEvent, ModelEvent payload) {
        DecisionModelMetadata decisionModelMetadata = payload.getDecisionModelMetadata();
        if (decisionModelMetadata.getType().equals((Object)DecisionModelMetadata.Type.DMN)) {
            ModelIdentifier identifier = new ModelIdentifier(payload.getGav().getGroupId(), payload.getGav().getArtifactId(), payload.getGav().getVersion(), payload.getName(), payload.getNamespace());
            DMNModelWithMetadata dmnModelWithMetadata = DMNModelWithMetadata.fromCloudEvent(payload);
            this.service.storeModel(identifier, dmnModelWithMetadata);
        } else {
            LOG.error("Unsupported DecisionModelType type {}", (Object)decisionModelMetadata.getType());
        }
    }
}

