/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.enums;

import java.util.Arrays;
import org.kie.pmml.api.exceptions.KieEnumException;

public enum OPERATOR {
    EQUAL("equal", "=="),
    NOT_EQUAL("notEqual", "!="),
    LESS_THAN("lessThan", "<"),
    LESS_OR_EQUAL("lessOrEqual", "<="),
    GREATER_THAN("greaterThan", ">"),
    GREATER_OR_EQUAL("greaterOrEqual", ">="),
    IS_MISSING("isMissing", ""),
    IS_NOT_MISSING("isNotMissing", "");

    private final String name;
    private final String operator;

    private OPERATOR(String name, String operator) {
        this.name = name;
        this.operator = operator;
    }

    public static OPERATOR byName(String name) {
        return Arrays.stream(OPERATOR.values()).filter(value -> name.equals(value.name)).findFirst().orElseThrow(() -> new KieEnumException("Failed to find OPERATOR with name: " + name));
    }

    public String getName() {
        return this.name;
    }

    public String getOperator() {
        return this.operator;
    }
}

