/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.common;

import io.opentelemetry.api.common.ArrayBackedAttributesBuilder;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.internal.ImmutableKeyValuePairs;
import java.util.ArrayList;
import java.util.Comparator;
import javax.annotation.concurrent.Immutable;

@Immutable
final class ArrayBackedAttributes
extends ImmutableKeyValuePairs<AttributeKey<?>, Object>
implements Attributes {
    private static final Comparator<AttributeKey<?>> KEY_COMPARATOR_FOR_CONSTRUCTION = Comparator.comparing(AttributeKey::getKey);
    static final Attributes EMPTY = Attributes.builder().build();

    private ArrayBackedAttributes(Object[] data, Comparator<AttributeKey<?>> keyComparator) {
        super(data, keyComparator);
    }

    @Override
    public AttributesBuilder toBuilder() {
        return new ArrayBackedAttributesBuilder(new ArrayList<Object>(this.data()));
    }

    @Override
    public <T> T get(AttributeKey<T> key) {
        return (T)super.get(key);
    }

    static Attributes sortAndFilterToAttributes(Object ... data) {
        for (int i = 0; i < data.length; i += 2) {
            AttributeKey key = (AttributeKey)data[i];
            if (key == null || key.getKey() != null && !"".equals(key.getKey())) continue;
            data[i] = null;
        }
        return new ArrayBackedAttributes(data, KEY_COMPARATOR_FOR_CONSTRUCTION);
    }
}

