/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devconsole.runtime.spi;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.devconsole.runtime.spi.FlashScopeUtil;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.impl.headers.VertxHttpHeaders;
import io.vertx.ext.web.RoutingContext;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;

public abstract class DevConsolePostHandler
implements Handler<RoutingContext> {
    @Override
    public void handle(final RoutingContext event) {
        if (event.getBody() != null) {
            String data = event.getBodyAsString();
            String[] parts = data.split("&");
            VertxHttpHeaders post = new VertxHttpHeaders();
            for (String i : parts) {
                String[] pair = i.split("=");
                try {
                    post.add(URLDecoder.decode(pair[0], StandardCharsets.UTF_8.name()), URLDecoder.decode(pair[1], StandardCharsets.UTF_8.name()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            this.dispatch(event, post);
        } else {
            event.request().setExpectMultipart(true);
            event.request().endHandler((Handler)new Handler<Void>(){

                @Override
                public void handle(Void ignore) {
                    DevConsolePostHandler.this.dispatch(event, event.request().formAttributes());
                }
            });
        }
    }

    protected void dispatch(final RoutingContext event, final MultiMap form) {
        try {
            this.handlePost(event, form);
            this.actionSuccess(event);
            return;
        }
        catch (NotImplementedException notImplementedException) {
        }
        catch (Exception e) {
            event.fail(e);
        }
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        DevConsolePostHandler.this.handlePostAsync(event, form);
                        DevConsolePostHandler.this.actionSuccess(event);
                    }
                    catch (Exception e) {
                        event.fail(e);
                    }
                }
            }, "DEV Console action").start();
            return;
        }
        catch (NotImplementedException e) {
            throw new RuntimeException("One of handlePost or handleAsyncPost must be implemented");
        }
        catch (Exception e) {
            event.fail(e);
            return;
        }
    }

    private void actionSuccess(RoutingContext event) {
        event.response().setStatusCode(HttpResponseStatus.SEE_OTHER.code()).headers().set((CharSequence)HttpHeaderNames.LOCATION, (CharSequence)event.request().absoluteURI());
        event.response().end();
    }

    protected void flashMessage(RoutingContext event, String message) {
        FlashScopeUtil.setFlashMessage(event, message);
    }

    protected void flashMessage(RoutingContext event, String message, Duration displayTime) {
        FlashScopeUtil.setFlashMessage(event, message, displayTime);
    }

    protected void flashMessage(RoutingContext event, String message, FlashScopeUtil.FlashMessageStatus messageStatus) {
        FlashScopeUtil.setFlashMessage(event, message, messageStatus, null);
    }

    protected void handlePost(RoutingContext event, MultiMap form) throws Exception {
        throw new NotImplementedException();
    }

    protected void handlePostAsync(RoutingContext event, MultiMap form) throws Exception {
        throw new NotImplementedException();
    }

    private static class NotImplementedException
    extends RuntimeException {
        private NotImplementedException() {
        }
    }
}

