/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.jaxrs;

import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="SRJWT", length=5)
interface JAXRSLogging
extends BasicLogger {
    public static final JAXRSLogging log = Logger.getMessageLogger(JAXRSLogging.class, JAXRSLogging.class.getPackage().getName());

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=10000, value="Success")
    public void success();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=10001, value="Unable to validate bearer token")
    public void unableToValidateBearerToken(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=10002, value="Failed to resolve the key. Either corrupt or unavailable.")
    public void noUsableKey();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=10003, value="EE Security is not in use, %s has been registered")
    public void eeSecurityNotInUseButRegistered(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=10004, value="MP-JWT LoginConfig present, %s is enabled")
    public void mpJWTLoginConfigPresent(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10005, value="LoginConfig not found on Application class, %s will not be enabled")
    public void mpJWTLoginConfigNotFound(String var1);
}

