/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.processors.BroadcastProcessor;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;

public class MultiTransform<T> {
    private final Multi<T> upstream;

    public MultiTransform(Multi<T> upstream) {
        this.upstream = upstream;
    }

    public Multi<T> bySkippingFirstItems(long number) {
        return this.upstream.skip().first(number);
    }

    public Multi<T> bySkippingLastItems(int number) {
        return this.upstream.skip().last(number);
    }

    public Multi<T> bySkippingItemsWhile(Predicate<? super T> predicate) {
        return this.upstream.skip().first(predicate);
    }

    public Multi<T> bySkippingItemsFor(Duration duration) {
        return this.upstream.skip().first(duration);
    }

    public Multi<T> byTakingFirstItems(long number) {
        return this.upstream.select().first(number);
    }

    public Multi<T> byTakingLastItems(int number) {
        return this.upstream.select().last(number);
    }

    public Multi<T> byTakingItemsFor(Duration duration) {
        return this.upstream.select().first(duration);
    }

    public Multi<T> byTakingItemsWhile(Predicate<? super T> predicate) {
        return this.upstream.select().first(predicate);
    }

    public Multi<T> byDroppingDuplicates() {
        return this.upstream.select().distinct();
    }

    public Multi<T> byDroppingRepetitions() {
        return this.upstream.skip().repetitions();
    }

    @SafeVarargs
    public final Multi<T> byMergingWith(Publisher<T> ... publishers) {
        ArrayList list = new ArrayList();
        list.add(this.upstream);
        list.addAll(Arrays.asList(ParameterValidation.nonNull(publishers, "publishers")));
        return Multi.createBy().merging().streams(list);
    }

    public Multi<T> byMergingWith(Iterable<Publisher<T>> iterable) {
        ArrayList list = new ArrayList();
        list.add(this.upstream);
        ParameterValidation.nonNull(iterable, "iterable").forEach(list::add);
        return Multi.createBy().merging().streams(list);
    }

    public Multi<T> byFilteringItemsWith(Predicate<? super T> predicate) {
        return this.upstream.select().where(predicate);
    }

    public Multi<T> byTestingItemsWith(Function<? super T, Uni<Boolean>> predicate) {
        return this.upstream.select().when(predicate);
    }

    @Deprecated
    public Multi<T> toHotStream() {
        BroadcastProcessor processor = BroadcastProcessor.create();
        this.upstream.subscribe(processor);
        return processor;
    }
}

