/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.util;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.models.info.ContactImpl;
import io.smallrye.openapi.api.models.info.LicenseImpl;
import io.smallrye.openapi.api.models.servers.ServerImpl;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.servers.Server;

public class ConfigUtil {
    private ConfigUtil() {
    }

    public static final void applyConfig(OpenApiConfig config, OpenAPI oai) {
        ConfigUtil.configureServers(config, oai);
        ConfigUtil.configureVersion(config, oai);
        ConfigUtil.configureInfo(config, oai);
    }

    protected static final void configureVersion(OpenApiConfig config, OpenAPI oai) {
        String versionInConfig = config.getOpenApiVersion();
        if (versionInConfig != null && !versionInConfig.isEmpty()) {
            oai.setOpenapi(versionInConfig);
        } else if (oai.getOpenapi() == null || oai.getOpenapi().isEmpty()) {
            oai.setOpenapi("3.0.3");
        }
    }

    protected static final void configureInfo(OpenApiConfig config, OpenAPI oai) {
        if (config.getInfoTitle() != null) {
            oai.getInfo().setTitle(config.getInfoTitle());
        }
        if (config.getInfoVersion() != null) {
            oai.getInfo().setVersion(config.getInfoVersion());
        }
        if (config.getInfoDescription() != null) {
            oai.getInfo().setDescription(config.getInfoDescription());
        }
        if (config.getInfoTermsOfService() != null) {
            oai.getInfo().setTermsOfService(config.getInfoTermsOfService());
        }
        if (oai.getInfo().getContact() == null && (config.getInfoContactEmail() != null || config.getInfoContactName() != null || config.getInfoContactUrl() != null)) {
            oai.getInfo().setContact(new ContactImpl());
        }
        if (config.getInfoContactEmail() != null) {
            oai.getInfo().getContact().setEmail(config.getInfoContactEmail());
        }
        if (config.getInfoContactName() != null) {
            oai.getInfo().getContact().setName(config.getInfoContactName());
        }
        if (config.getInfoContactUrl() != null) {
            oai.getInfo().getContact().setUrl(config.getInfoContactUrl());
        }
        if (oai.getInfo().getLicense() == null && (config.getInfoLicenseName() != null || config.getInfoLicenseUrl() != null)) {
            oai.getInfo().setLicense(new LicenseImpl());
        }
        if (config.getInfoLicenseName() != null) {
            oai.getInfo().getLicense().setName(config.getInfoLicenseName());
        }
        if (config.getInfoLicenseUrl() != null) {
            oai.getInfo().getLicense().setUrl(config.getInfoLicenseUrl());
        }
    }

    protected static final void configureServers(OpenApiConfig config, OpenAPI oai) {
        Map<String, PathItem> pathItems;
        Set<String> servers = config.servers();
        if (servers != null && !servers.isEmpty()) {
            oai.servers(new ArrayList<Server>());
            for (String server : servers) {
                ServerImpl s = new ServerImpl();
                s.setUrl(server);
                oai.addServer(s);
            }
        }
        if ((pathItems = oai.getPaths().getPathItems()) != null) {
            pathItems.entrySet().forEach(entry -> ConfigUtil.configureServers(config, (String)entry.getKey(), (PathItem)entry.getValue()));
        }
    }

    protected static void configureServers(OpenApiConfig config, String pathName, PathItem pathItem) {
        if (pathItem == null) {
            return;
        }
        Set<String> pathServers = config.pathServers(pathName);
        if (pathServers != null && !pathServers.isEmpty()) {
            pathItem.servers(new ArrayList<Server>());
            for (String pathServer : pathServers) {
                ServerImpl server = new ServerImpl();
                server.setUrl(pathServer);
                pathItem.addServer(server);
            }
        }
        ConfigUtil.configureServers(config, pathItem.getGET());
        ConfigUtil.configureServers(config, pathItem.getPUT());
        ConfigUtil.configureServers(config, pathItem.getPOST());
        ConfigUtil.configureServers(config, pathItem.getDELETE());
        ConfigUtil.configureServers(config, pathItem.getHEAD());
        ConfigUtil.configureServers(config, pathItem.getOPTIONS());
        ConfigUtil.configureServers(config, pathItem.getPATCH());
        ConfigUtil.configureServers(config, pathItem.getTRACE());
    }

    protected static void configureServers(OpenApiConfig config, Operation operation) {
        if (operation == null) {
            return;
        }
        if (operation.getOperationId() == null) {
            return;
        }
        Set<String> operationServers = config.operationServers(operation.getOperationId());
        if (operationServers != null && !operationServers.isEmpty()) {
            operation.servers(new ArrayList<Server>());
            for (String operationServer : operationServers) {
                ServerImpl server = new ServerImpl();
                server.setUrl(operationServer);
                operation.addServer(server);
            }
        }
    }
}

