/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.common;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.explainability.api.CounterfactualExplainabilityRequestDto;
import org.kie.kogito.explainability.api.LIMEExplainabilityRequestDto;
import org.kie.kogito.explainability.api.ModelIdentifierDto;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.query.AttributeFilter;
import org.kie.kogito.persistence.api.query.QueryFilterFactory;
import org.kie.kogito.persistence.api.query.SortDirection;
import org.kie.kogito.trusty.service.common.TrustyService;
import org.kie.kogito.trusty.service.common.handlers.ExplainerServiceHandlerRegistry;
import org.kie.kogito.trusty.service.common.messaging.MessagingUtils;
import org.kie.kogito.trusty.service.common.messaging.incoming.ModelIdentifier;
import org.kie.kogito.trusty.service.common.messaging.outgoing.ExplainabilityRequestProducer;
import org.kie.kogito.trusty.service.common.models.MatchedExecutionHeaders;
import org.kie.kogito.trusty.storage.api.model.BaseExplainabilityResult;
import org.kie.kogito.trusty.storage.api.model.CounterfactualExplainabilityRequest;
import org.kie.kogito.trusty.storage.api.model.CounterfactualSearchDomain;
import org.kie.kogito.trusty.storage.api.model.DMNModelWithMetadata;
import org.kie.kogito.trusty.storage.api.model.Decision;
import org.kie.kogito.trusty.storage.api.model.TypedVariableWithValue;
import org.kie.kogito.trusty.storage.common.TrustyStorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class TrustyServiceImpl
implements TrustyService {
    private static final Logger LOG = LoggerFactory.getLogger(TrustyServiceImpl.class);
    private boolean isExplainabilityEnabled;
    private ExplainabilityRequestProducer explainabilityRequestProducer;
    private TrustyStorageService storageService;
    private ExplainerServiceHandlerRegistry explainerServiceHandlerRegistry;

    TrustyServiceImpl() {
    }

    @Inject
    public TrustyServiceImpl(@ConfigProperty(name="trusty.explainability.enabled") Boolean isExplainabilityEnabled, ExplainabilityRequestProducer explainabilityRequestProducer, TrustyStorageService storageService, ExplainerServiceHandlerRegistry explainerServiceHandlerRegistry) {
        this.isExplainabilityEnabled = Boolean.TRUE.equals(isExplainabilityEnabled);
        this.explainabilityRequestProducer = explainabilityRequestProducer;
        this.storageService = storageService;
        this.explainerServiceHandlerRegistry = explainerServiceHandlerRegistry;
    }

    void enableExplainability() {
        this.isExplainabilityEnabled = true;
    }

    @Override
    public MatchedExecutionHeaders getExecutionHeaders(OffsetDateTime from, OffsetDateTime to, int limit, int offset, String prefix) {
        Storage<String, Decision> storage = this.storageService.getDecisionsStorage();
        ArrayList filters = new ArrayList();
        filters.add(QueryFilterFactory.like("executionId", prefix + "*"));
        filters.add(QueryFilterFactory.greaterThanEqual("executionTimestamp", from.toInstant().toEpochMilli()));
        filters.add(QueryFilterFactory.lessThanEqual("executionTimestamp", to.toInstant().toEpochMilli()));
        ArrayList<Decision> result = new ArrayList<Decision>(storage.query().sort(Arrays.asList(QueryFilterFactory.orderBy("executionTimestamp", SortDirection.DESC))).filter(filters).execute());
        if (result.size() < offset) {
            throw new IllegalArgumentException("Out of bound start offset in result");
        }
        return new MatchedExecutionHeaders(result.subList(offset, Math.min(offset + limit, result.size())), result.size());
    }

    @Override
    public void storeDecision(String executionId, Decision decision) {
        Storage<String, Decision> storage = this.storageService.getDecisionsStorage();
        if (storage.containsKey(executionId)) {
            throw new IllegalArgumentException(String.format("A decision with ID %s is already present in the storage.", executionId));
        }
        storage.put(executionId, decision);
    }

    @Override
    public Decision getDecisionById(String executionId) {
        Storage<String, Decision> storage = this.storageService.getDecisionsStorage();
        if (!storage.containsKey(executionId)) {
            throw new IllegalArgumentException(String.format("A decision with ID %s does not exist in the storage.", executionId));
        }
        return storage.get(executionId);
    }

    @Override
    public void updateDecision(String executionId, Decision decision) {
        this.storageService.getDecisionsStorage().put(executionId, decision);
    }

    @Override
    public void processDecision(String executionId, Decision decision) {
        this.storeDecision(executionId, decision);
        if (this.isExplainabilityEnabled) {
            Map inputs = decision.getInputs() != null ? (Map)decision.getInputs().stream().collect(HashMap::new, (m, v) -> m.put(v.getName(), MessagingUtils.modelToTracingTypedValue(v.getValue())), HashMap::putAll) : Collections.emptyMap();
            Map outputs = decision.getOutcomes() != null ? (Map)decision.getOutcomes().stream().collect(HashMap::new, (m, v) -> m.put(v.getOutcomeName(), MessagingUtils.modelToTracingTypedValue(v.getOutcomeResult())), HashMap::putAll) : Collections.emptyMap();
            this.explainabilityRequestProducer.sendEvent(new LIMEExplainabilityRequestDto(executionId, decision.getServiceUrl(), this.createDecisionModelIdentifierDto(decision), inputs, outputs));
        }
    }

    @Override
    public <T extends BaseExplainabilityResult> void storeExplainabilityResult(String executionId, T result) {
        this.explainerServiceHandlerRegistry.storeExplainabilityResult(executionId, result);
    }

    @Override
    public <T extends BaseExplainabilityResult> T getExplainabilityResultById(String executionId, Class<T> type) {
        return this.explainerServiceHandlerRegistry.getExplainabilityResultById(executionId, type);
    }

    @Override
    public void storeModel(ModelIdentifier modelIdentifier, DMNModelWithMetadata dmnModelWithMetadata) {
        Storage<String, DMNModelWithMetadata> storage = this.storageService.getModelStorage();
        if (storage.containsKey(modelIdentifier.getIdentifier())) {
            throw new IllegalArgumentException(String.format("A model with ID %s is already present in the storage.", modelIdentifier.getIdentifier()));
        }
        storage.put(modelIdentifier.getIdentifier(), dmnModelWithMetadata);
    }

    @Override
    public DMNModelWithMetadata getModelById(ModelIdentifier modelIdentifier) {
        Storage<String, DMNModelWithMetadata> storage = this.storageService.getModelStorage();
        if (!storage.containsKey(modelIdentifier.getIdentifier())) {
            throw new IllegalArgumentException(String.format("A model with ID %s does not exist in the storage.", modelIdentifier.getIdentifier()));
        }
        return storage.get(modelIdentifier.getIdentifier());
    }

    @Override
    public CounterfactualExplainabilityRequest requestCounterfactuals(String executionId, List<TypedVariableWithValue> goals, List<CounterfactualSearchDomain> searchDomains) {
        Storage<String, Decision> storage = this.storageService.getDecisionsStorage();
        if (!storage.containsKey(executionId)) {
            throw new IllegalArgumentException(String.format("A decision with ID %s is not present in the storage. Counterfactuals cannot be requested.", executionId));
        }
        CounterfactualExplainabilityRequest counterfactualRequest = this.storeCounterfactualRequest(executionId, goals, searchDomains);
        this.sendCounterfactualRequestEvent(executionId, counterfactualRequest.getCounterfactualId(), goals, searchDomains);
        return counterfactualRequest;
    }

    protected CounterfactualExplainabilityRequest storeCounterfactualRequest(String executionId, List<TypedVariableWithValue> goals, List<CounterfactualSearchDomain> searchDomains) {
        String counterfactualId = UUID.randomUUID().toString();
        CounterfactualExplainabilityRequest counterfactualRequest = new CounterfactualExplainabilityRequest(executionId, counterfactualId, goals, searchDomains);
        Storage<String, CounterfactualExplainabilityRequest> storage = this.storageService.getCounterfactualRequestStorage();
        storage.put(counterfactualId, counterfactualRequest);
        return counterfactualRequest;
    }

    protected void sendCounterfactualRequestEvent(String executionId, String counterfactualId, List<TypedVariableWithValue> goals, List<CounterfactualSearchDomain> searchDomains) {
        Decision decision = this.getDecisionById(executionId);
        Map originalInputs = decision.getInputs() != null ? (Map)decision.getInputs().stream().collect(HashMap::new, (m, v) -> m.put(v.getName(), MessagingUtils.modelToTracingTypedValue(v.getValue())), HashMap::putAll) : Collections.emptyMap();
        Map requiredOutputs = goals != null ? (Map)goals.stream().collect(HashMap::new, (m, v) -> m.put(v.getName(), MessagingUtils.modelToTracingTypedValue(v)), HashMap::putAll) : Collections.emptyMap();
        Map searchDomainDtos = searchDomains != null ? (Map)searchDomains.stream().collect(HashMap::new, (m, v) -> m.put(v.getName(), MessagingUtils.modelToCounterfactualSearchDomainDto(v)), HashMap::putAll) : Collections.emptyMap();
        this.explainabilityRequestProducer.sendEvent(new CounterfactualExplainabilityRequestDto(executionId, counterfactualId, decision.getServiceUrl(), this.createDecisionModelIdentifierDto(decision), originalInputs, requiredOutputs, searchDomainDtos));
    }

    @Override
    public List<CounterfactualExplainabilityRequest> getCounterfactualRequests(String executionId) {
        Storage<String, CounterfactualExplainabilityRequest> storage = this.storageService.getCounterfactualRequestStorage();
        AttributeFilter<String> filterExecutionId = QueryFilterFactory.equalTo("executionId", executionId);
        List<CounterfactualExplainabilityRequest> counterfactuals = storage.query().filter(Collections.singletonList(filterExecutionId)).execute();
        return List.copyOf(counterfactuals);
    }

    @Override
    public CounterfactualExplainabilityRequest getCounterfactualRequest(String executionId, String counterfactualId) {
        Storage<String, CounterfactualExplainabilityRequest> storage = this.storageService.getCounterfactualRequestStorage();
        AttributeFilter<String> filterExecutionId = QueryFilterFactory.equalTo("executionId", executionId);
        AttributeFilter<String> filterCounterfactualId = QueryFilterFactory.equalTo("counterfactualId", counterfactualId);
        List<AttributeFilter<?>> filters = List.of(filterExecutionId, filterCounterfactualId);
        List<CounterfactualExplainabilityRequest> counterfactuals = storage.query().filter(filters).execute();
        if (counterfactuals.isEmpty()) {
            throw new IllegalArgumentException(String.format("Counterfactual for Execution Id '%s' and Counterfactual Id '%s' does not exist in the storage.", executionId, counterfactualId));
        }
        if (counterfactuals.size() > 1) {
            throw new IllegalArgumentException(String.format("Multiple Counterfactuals for Execution Id '%s' and Counterfactual Id '%s' found in the storage.", executionId, counterfactualId));
        }
        return counterfactuals.get(0);
    }

    private ModelIdentifierDto createDecisionModelIdentifierDto(Decision decision) {
        String resourceId = decision.getExecutedModelNamespace() + ":" + decision.getExecutedModelName();
        return new ModelIdentifierDto("dmn", resourceId);
    }
}

