/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.format.EventDeserializationException;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.format.EventSerializationException;
import io.cloudevents.jackson.CloudEventDeserializer;
import io.cloudevents.jackson.CloudEventSerializer;
import java.io.IOException;

public final class JsonFormat
implements EventFormat {
    public static final String CONTENT_TYPE = "application/cloudevents+json";
    private final ObjectMapper mapper = new ObjectMapper();
    private final boolean forceDataBase64Serialization;
    private final boolean forceStringSerialization;

    public JsonFormat(boolean forceDataBase64Serialization, boolean forceStringSerialization) {
        this.mapper.registerModule(JsonFormat.getCloudEventJacksonModule(forceDataBase64Serialization, forceStringSerialization));
        this.forceDataBase64Serialization = forceDataBase64Serialization;
        this.forceStringSerialization = forceStringSerialization;
    }

    public JsonFormat() {
        this(false, false);
    }

    public JsonFormat withForceJsonDataToBase64() {
        return new JsonFormat(true, this.forceStringSerialization);
    }

    public JsonFormat withForceNonJsonDataToString() {
        return new JsonFormat(this.forceDataBase64Serialization, true);
    }

    @Override
    public byte[] serialize(CloudEvent event) throws EventSerializationException {
        try {
            return this.mapper.writeValueAsBytes(event);
        }
        catch (JsonProcessingException e) {
            throw new EventSerializationException(e);
        }
    }

    @Override
    public CloudEvent deserialize(byte[] bytes) throws EventDeserializationException {
        try {
            return this.mapper.readValue(bytes, CloudEvent.class);
        }
        catch (IOException e) {
            throw new EventDeserializationException(e);
        }
    }

    @Override
    public String serializedContentType() {
        return CONTENT_TYPE;
    }

    public static SimpleModule getCloudEventJacksonModule() {
        return JsonFormat.getCloudEventJacksonModule(false, false);
    }

    public static SimpleModule getCloudEventJacksonModule(boolean forceDataBase64Serialization, boolean forceStringSerialization) {
        SimpleModule ceModule = new SimpleModule("CloudEvent");
        ceModule.addSerializer(CloudEvent.class, new CloudEventSerializer(forceDataBase64Serialization, forceStringSerialization));
        ceModule.addDeserializer(CloudEvent.class, new CloudEventDeserializer());
        return ceModule;
    }

    protected static boolean dataIsJsonContentType(String contentType) {
        return contentType == null || contentType.startsWith("application/json") || contentType.startsWith("text/json");
    }
}

