/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.smallrye.common.annotation.Experimental;
import java.util.Optional;
import org.eclipse.microprofile.reactive.messaging.Message;

@Experimental(value="Tracer metadata is a SmallRye specific feature for integrating with OpenTelemetry")
public class TracingMetadata {
    private static final TracingMetadata EMPTY = new TracingMetadata(null);
    private final SpanContext currentSpanContext;
    private final Context previousSpanContext;

    private TracingMetadata(SpanContext spanContext) {
        this(spanContext, null);
    }

    private TracingMetadata(SpanContext spanContext, Context previousSpanContext) {
        this.currentSpanContext = spanContext;
        this.previousSpanContext = previousSpanContext;
    }

    public static TracingMetadata empty() {
        return EMPTY;
    }

    public static Optional<TracingMetadata> fromMessage(Message<?> message) {
        return message.getMetadata(TracingMetadata.class);
    }

    public static TracingMetadata withPrevious(Context previousContext) {
        if (previousContext != null) {
            return new TracingMetadata(null, previousContext);
        }
        return EMPTY;
    }

    public TracingMetadata withSpan(Span span) {
        if (span != null) {
            return new TracingMetadata(span.getSpanContext(), this.previousSpanContext);
        }
        return this;
    }

    public SpanContext getCurrentSpanContext() {
        return this.currentSpanContext;
    }

    public Context getPreviousContext() {
        return this.previousSpanContext;
    }
}

