/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka;

import io.smallrye.reactive.messaging.kafka.KafkaConnectorCommonConfiguration;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;

public class KafkaConnectorOutgoingConfiguration
extends KafkaConnectorCommonConfiguration {
    public KafkaConnectorOutgoingConfiguration(Config config) {
        super(config);
        this.validate();
    }

    public String getKeySerializer() {
        return this.config.getOptionalValue("key.serializer", String.class).orElse("org.apache.kafka.common.serialization.StringSerializer");
    }

    public String getValueSerializer() {
        return this.config.getOptionalValue("value.serializer", String.class).orElseThrow(() -> new IllegalArgumentException("The attribute `value.serializer` on connector 'smallrye-kafka' (channel: " + this.getChannel() + ") must be set"));
    }

    public String getAcks() {
        return this.config.getOptionalValue("acks", String.class).orElse("1");
    }

    public Long getBufferMemory() {
        return this.config.getOptionalValue("buffer.memory", Long.class).orElse(Long.valueOf("33554432"));
    }

    public Long getRetries() {
        return this.config.getOptionalValue("retries", Long.class).orElse(Long.valueOf("2147483647"));
    }

    public Optional<String> getKey() {
        return this.config.getOptionalValue("key", String.class);
    }

    public Integer getPartition() {
        return this.config.getOptionalValue("partition", Integer.class).orElse(Integer.valueOf("-1"));
    }

    public Boolean getWaitForWriteCompletion() {
        return this.config.getOptionalValue("waitForWriteCompletion", Boolean.class).orElse(Boolean.valueOf("true"));
    }

    public Long getMaxInflightMessages() {
        return this.config.getOptionalValue("max-inflight-messages", Long.class).orElse(Long.valueOf("1024"));
    }

    public Optional<String> getCloudEventsSource() {
        Optional<String> maybe = this.config.getOptionalValue("cloud-events-source", String.class);
        if (maybe.isPresent()) {
            return maybe;
        }
        return this.getFromAlias("cloud-events-default-source", String.class);
    }

    public Optional<String> getCloudEventsType() {
        Optional<String> maybe = this.config.getOptionalValue("cloud-events-type", String.class);
        if (maybe.isPresent()) {
            return maybe;
        }
        return this.getFromAlias("cloud-events-default-type", String.class);
    }

    public Optional<String> getCloudEventsSubject() {
        Optional<String> maybe = this.config.getOptionalValue("cloud-events-subject", String.class);
        if (maybe.isPresent()) {
            return maybe;
        }
        return this.getFromAlias("cloud-events-default-subject", String.class);
    }

    public Optional<String> getCloudEventsDataContentType() {
        Optional<String> maybe = this.config.getOptionalValue("cloud-events-data-content-type", String.class);
        if (maybe.isPresent()) {
            return maybe;
        }
        return this.getFromAlias("cloud-events-default-data-content-type", String.class);
    }

    public Optional<String> getCloudEventsDataSchema() {
        Optional<String> maybe = this.config.getOptionalValue("cloud-events-data-schema", String.class);
        if (maybe.isPresent()) {
            return maybe;
        }
        return this.getFromAlias("cloud-events-default-data-schema", String.class);
    }

    public Boolean getCloudEventsInsertTimestamp() {
        return this.config.getOptionalValue("cloud-events-insert-timestamp", Boolean.class).orElseGet(() -> this.getFromAliasWithDefaultValue("cloud-events-default-timestamp", Boolean.class, Boolean.valueOf("true")));
    }

    public String getCloudEventsMode() {
        return this.config.getOptionalValue("cloud-events-mode", String.class).orElse("binary");
    }

    public Integer getCloseTimeout() {
        return this.config.getOptionalValue("close-timeout", Integer.class).orElse(Integer.valueOf("10000"));
    }

    public Boolean getMerge() {
        return this.config.getOptionalValue("merge", Boolean.class).orElse(Boolean.valueOf("false"));
    }

    @Override
    public void validate() {
        super.validate();
        this.getValueSerializer();
    }
}

