/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.fault;

import io.smallrye.reactive.messaging.kafka.IncomingKafkaRecord;
import io.smallrye.reactive.messaging.kafka.KafkaCDIEvents;
import io.smallrye.reactive.messaging.kafka.KafkaConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.kafka.OutgoingKafkaRecordMetadata;
import io.smallrye.reactive.messaging.kafka.fault.KafkaFailureHandler;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import io.smallrye.reactive.messaging.kafka.impl.ConfigurationCleaner;
import io.smallrye.reactive.messaging.kafka.impl.KafkaSource;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.kafka.client.producer.KafkaHeader;
import io.vertx.mutiny.kafka.client.producer.KafkaProducer;
import io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.common.serialization.StringSerializer;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class KafkaDeadLetterQueue
implements KafkaFailureHandler {
    public static final String DEAD_LETTER_REASON = "dead-letter-reason";
    public static final String DEAD_LETTER_CAUSE = "dead-letter-cause";
    public static final String DEAD_LETTER_TOPIC = "dead-letter-topic";
    public static final String DEAD_LETTER_OFFSET = "dead-letter-offset";
    public static final String DEAD_LETTER_PARTITION = "dead-letter-partition";
    private final String channel;
    private final KafkaProducer producer;
    private final String topic;
    private final KafkaSource<?, ?> source;

    public KafkaDeadLetterQueue(String channel, String topic, KafkaProducer producer, KafkaSource<?, ?> source) {
        this.channel = channel;
        this.topic = topic;
        this.producer = producer;
        this.source = source;
    }

    public static KafkaFailureHandler create(Vertx vertx, Map<String, ?> kafkaConfiguration, KafkaConnectorIncomingConfiguration conf, KafkaSource<?, ?> source, KafkaCDIEvents kafkaCDIEvents) {
        HashMap<String, String> deadQueueProducerConfig = new HashMap<String, String>();
        kafkaConfiguration.forEach((key, value) -> deadQueueProducerConfig.put((String)key, (String)value));
        String keyDeserializer = (String)deadQueueProducerConfig.remove("key.deserializer");
        String valueDeserializer = (String)deadQueueProducerConfig.remove("value.deserializer");
        deadQueueProducerConfig.remove("interceptor.classes");
        deadQueueProducerConfig.put("key.serializer", conf.getDeadLetterQueueKeySerializer().orElse(KafkaDeadLetterQueue.getMirrorSerializer(keyDeserializer)));
        deadQueueProducerConfig.put("value.serializer", conf.getDeadLetterQueueValueSerializer().orElse(KafkaDeadLetterQueue.getMirrorSerializer(valueDeserializer)));
        deadQueueProducerConfig.put("client.id", "kafka-dead-letter-topic-producer-" + conf.getChannel());
        ConfigurationCleaner.cleanupProducerConfiguration(deadQueueProducerConfig);
        String deadQueueTopic = conf.getDeadLetterQueueTopic().orElse("dead-letter-topic-" + conf.getChannel());
        KafkaLogging.log.deadLetterConfig(deadQueueTopic, (String)deadQueueProducerConfig.get("key.serializer"), (String)deadQueueProducerConfig.get("value.serializer"));
        KafkaProducer producer = KafkaProducer.create(vertx, deadQueueProducerConfig);
        kafkaCDIEvents.producer().fire(producer.getDelegate().unwrap());
        return new KafkaDeadLetterQueue(conf.getChannel(), deadQueueTopic, producer, source);
    }

    private static String getMirrorSerializer(String deserializer) {
        if (deserializer == null) {
            return StringSerializer.class.getName();
        }
        return deserializer.replace("Deserializer", "Serializer");
    }

    private String getThrowableMessage(Throwable throwable) {
        String text = throwable.getMessage();
        if (text == null) {
            text = throwable.toString();
        }
        return text;
    }

    @Override
    public <K, V> CompletionStage<Void> handle(IncomingKafkaRecord<K, V> record, Throwable reason, Metadata metadata) {
        OutgoingKafkaRecordMetadata outgoing = metadata != null ? (OutgoingKafkaRecordMetadata)metadata.get(OutgoingKafkaRecordMetadata.class).orElse(null) : null;
        String topic = this.topic;
        if (outgoing != null && outgoing.getTopic() != null) {
            topic = outgoing.getTopic();
        }
        K key = record.getKey();
        if (outgoing != null && outgoing.getKey() != null) {
            key = outgoing.getKey();
        }
        Integer partition = null;
        if (outgoing != null && outgoing.getPartition() >= 0) {
            partition = outgoing.getPartition();
        }
        KafkaProducerRecord dead = KafkaProducerRecord.create(topic, key, record.getPayload(), null, partition);
        dead.addHeader(DEAD_LETTER_REASON, this.getThrowableMessage(reason));
        if (reason.getCause() != null) {
            dead.addHeader(DEAD_LETTER_CAUSE, this.getThrowableMessage(reason.getCause()));
        }
        dead.addHeader(DEAD_LETTER_TOPIC, record.getTopic());
        dead.addHeader(DEAD_LETTER_PARTITION, Integer.toString(record.getPartition()));
        dead.addHeader(DEAD_LETTER_OFFSET, Long.toString(record.getOffset()));
        record.getHeaders().forEach(header -> dead.addHeader(KafkaHeader.header(header.key(), Buffer.buffer(header.value()))));
        if (outgoing != null && outgoing.getHeaders() != null) {
            outgoing.getHeaders().forEach(header -> dead.addHeader(KafkaHeader.header(header.key(), Buffer.buffer(header.value()))));
        }
        KafkaLogging.log.messageNackedDeadLetter(this.channel, topic);
        return this.producer.send(dead).onFailure().invoke(t -> this.source.reportFailure((Throwable)t, true)).onItem().ignore().andContinueWithNull().subscribeAsCompletionStage().thenCompose(m -> record.ack());
    }

    @Override
    public void terminate() {
        this.producer.closeAndAwait();
    }
}

