/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.specimpl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Variant;

public class VariantListBuilderImpl
extends Variant.VariantListBuilder {
    private ArrayList<Variant> variants = new ArrayList();
    private ArrayList<Locale> currentLanguages = new ArrayList();
    private ArrayList<String> currentEncodings = new ArrayList();
    private ArrayList<MediaType> currentTypes = new ArrayList();

    @Override
    public List<Variant> build() {
        this.add();
        ArrayList<Variant> copy = new ArrayList<Variant>();
        copy.addAll(this.variants);
        this.variants.clear();
        this.currentLanguages.clear();
        this.currentEncodings.clear();
        this.currentTypes.clear();
        return copy;
    }

    @Override
    public Variant.VariantListBuilder add() {
        int langSize = this.currentLanguages.size();
        int encodingSize = this.currentEncodings.size();
        int typeSize = this.currentTypes.size();
        int i = 0;
        if (langSize == 0 && encodingSize == 0 && typeSize == 0) {
            return this;
        }
        do {
            MediaType type = null;
            if (i < typeSize) {
                type = this.currentTypes.get(i);
            }
            int j = 0;
            do {
                String encoding = null;
                if (j < encodingSize) {
                    encoding = this.currentEncodings.get(j);
                }
                int k = 0;
                do {
                    Locale language = null;
                    if (k < langSize) {
                        language = this.currentLanguages.get(k);
                    }
                    this.variants.add(new Variant(type, language, encoding));
                } while (++k < langSize);
            } while (++j < encodingSize);
        } while (++i < typeSize);
        this.currentLanguages.clear();
        this.currentEncodings.clear();
        this.currentTypes.clear();
        return this;
    }

    @Override
    public Variant.VariantListBuilder languages(Locale ... languages) {
        for (Locale language : languages) {
            this.currentLanguages.add(language);
        }
        return this;
    }

    @Override
    public Variant.VariantListBuilder encodings(String ... encodings) {
        for (String encoding : encodings) {
            this.currentEncodings.add(encoding);
        }
        return this;
    }

    @Override
    public Variant.VariantListBuilder mediaTypes(MediaType ... mediaTypes) {
        for (MediaType type : mediaTypes) {
            this.currentTypes.add(type);
        }
        return this;
    }
}

