/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.storage.api.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.tracing.typedvalue.TypedValue;
import org.kie.kogito.trusty.storage.api.model.CounterfactualDomain;
import org.kie.kogito.trusty.storage.api.model.CounterfactualDomainCategorical;
import org.kie.kogito.trusty.storage.api.model.CounterfactualDomainRange;
import org.kie.kogito.trusty.storage.api.model.CounterfactualSearchDomain;

public class CounterfactualDomainSerialisationTest {
    private ObjectMapper mapper;
    private StringWriter writer;

    @BeforeEach
    public void setup() {
        this.mapper = new ObjectMapper();
        this.writer = new StringWriter();
    }

    @Test
    public void testCounterfactualSearchDomain_Range_RoundTrip() throws Exception {
        CounterfactualDomainRange domainRange = new CounterfactualDomainRange((JsonNode)new IntNode(18), (JsonNode)new IntNode(65));
        CounterfactualSearchDomain searchDomain = new CounterfactualSearchDomain(TypedValue.Kind.UNIT, "age", "integer", null, Boolean.TRUE, (CounterfactualDomain)domainRange);
        this.mapper.writeValue((Writer)this.writer, (Object)searchDomain);
        String searchDomainJson = this.writer.toString();
        Assertions.assertNotNull((Object)searchDomainJson);
        CounterfactualSearchDomain roundTrippedSearchDomain = (CounterfactualSearchDomain)this.mapper.readValue(searchDomainJson, CounterfactualSearchDomain.class);
        Assertions.assertEquals((Object)searchDomain.getKind(), (Object)roundTrippedSearchDomain.getKind());
        Assertions.assertEquals((Object)searchDomain.getName(), (Object)roundTrippedSearchDomain.getName());
        Assertions.assertEquals((Object)searchDomain.getTypeRef(), (Object)roundTrippedSearchDomain.getTypeRef());
        Assertions.assertNull((Object)roundTrippedSearchDomain.getComponents());
        Assertions.assertEquals((Object)searchDomain.isFixed(), (Object)roundTrippedSearchDomain.isFixed());
        Assertions.assertTrue((boolean)(roundTrippedSearchDomain.getDomain() instanceof CounterfactualDomainRange));
        CounterfactualDomainRange roundTrippedDomainRange = (CounterfactualDomainRange)roundTrippedSearchDomain.getDomain();
        Assertions.assertEquals((Object)domainRange.getLowerBound(), (Object)roundTrippedDomainRange.getLowerBound());
        Assertions.assertEquals((Object)domainRange.getUpperBound(), (Object)roundTrippedDomainRange.getUpperBound());
    }

    @Test
    public void testCounterfactualSearchDomain_Categorical_RoundTrip() throws Exception {
        CounterfactualDomainCategorical domainCategorical = new CounterfactualDomainCategorical(List.of(new TextNode("A"), new TextNode("B")));
        CounterfactualSearchDomain searchDomain = new CounterfactualSearchDomain(TypedValue.Kind.UNIT, "age", "integer", null, Boolean.TRUE, (CounterfactualDomain)domainCategorical);
        this.mapper.writeValue((Writer)this.writer, (Object)searchDomain);
        String searchDomainJson = this.writer.toString();
        Assertions.assertNotNull((Object)searchDomainJson);
        CounterfactualSearchDomain roundTrippedSearchDomain = (CounterfactualSearchDomain)this.mapper.readValue(searchDomainJson, CounterfactualSearchDomain.class);
        Assertions.assertEquals((Object)searchDomain.getKind(), (Object)roundTrippedSearchDomain.getKind());
        Assertions.assertEquals((Object)searchDomain.getName(), (Object)roundTrippedSearchDomain.getName());
        Assertions.assertEquals((Object)searchDomain.getTypeRef(), (Object)roundTrippedSearchDomain.getTypeRef());
        Assertions.assertNull((Object)roundTrippedSearchDomain.getComponents());
        Assertions.assertEquals((Object)searchDomain.isFixed(), (Object)roundTrippedSearchDomain.isFixed());
        Assertions.assertTrue((boolean)(roundTrippedSearchDomain.getDomain() instanceof CounterfactualDomainCategorical));
        CounterfactualDomainCategorical roundTrippedDomainCategorical = (CounterfactualDomainCategorical)roundTrippedSearchDomain.getDomain();
        Assertions.assertEquals((int)domainCategorical.getCategories().size(), (int)roundTrippedDomainCategorical.getCategories().size());
        Assertions.assertTrue((boolean)roundTrippedDomainCategorical.getCategories().containsAll(domainCategorical.getCategories()));
    }
}

