/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.storage.api.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.api.CounterfactualDomain;
import org.kie.kogito.explainability.api.CounterfactualDomainCategorical;
import org.kie.kogito.explainability.api.CounterfactualDomainRange;
import org.kie.kogito.explainability.api.CounterfactualSearchDomain;
import org.kie.kogito.explainability.api.CounterfactualSearchDomainUnitValue;
import org.kie.kogito.explainability.api.CounterfactualSearchDomainValue;

public class CounterfactualDomainSerialisationTest {
    private ObjectMapper mapper;
    private StringWriter writer;

    @BeforeEach
    public void setup() {
        this.mapper = new ObjectMapper();
        this.writer = new StringWriter();
    }

    @Test
    public void testCounterfactualSearchDomain_Range_RoundTrip() throws Exception {
        CounterfactualDomainRange domainRange = new CounterfactualDomainRange((JsonNode)new IntNode(18), (JsonNode)new IntNode(65));
        CounterfactualSearchDomain searchDomain = new CounterfactualSearchDomain("age", (CounterfactualSearchDomainValue)new CounterfactualSearchDomainUnitValue("integer", "integer", Boolean.TRUE, (CounterfactualDomain)domainRange));
        this.mapper.writeValue((Writer)this.writer, (Object)searchDomain);
        String searchDomainJson = this.writer.toString();
        Assertions.assertNotNull((Object)searchDomainJson);
        CounterfactualSearchDomain roundTrippedSearchDomain = (CounterfactualSearchDomain)this.mapper.readValue(searchDomainJson, CounterfactualSearchDomain.class);
        Assertions.assertTrue((boolean)(roundTrippedSearchDomain.getValue() instanceof CounterfactualSearchDomainUnitValue));
        Assertions.assertEquals((Object)searchDomain.getValue().getKind(), (Object)roundTrippedSearchDomain.getValue().getKind());
        Assertions.assertEquals((Object)searchDomain.getName(), (Object)roundTrippedSearchDomain.getName());
        Assertions.assertEquals((Object)searchDomain.getValue().getType(), (Object)roundTrippedSearchDomain.getValue().getType());
        Assertions.assertEquals((Object)((CounterfactualSearchDomainUnitValue)searchDomain.getValue().toUnit()).getBaseType(), (Object)((CounterfactualSearchDomainUnitValue)roundTrippedSearchDomain.getValue().toUnit()).getBaseType());
        Assertions.assertEquals((Object)((CounterfactualSearchDomainUnitValue)searchDomain.getValue().toUnit()).isFixed(), (Object)((CounterfactualSearchDomainUnitValue)roundTrippedSearchDomain.getValue().toUnit()).isFixed());
        Assertions.assertTrue((boolean)(((CounterfactualSearchDomainUnitValue)roundTrippedSearchDomain.getValue().toUnit()).getDomain() instanceof CounterfactualDomainRange));
        CounterfactualDomainRange roundTrippedDomainRange = (CounterfactualDomainRange)((CounterfactualSearchDomainUnitValue)roundTrippedSearchDomain.getValue().toUnit()).getDomain();
        Assertions.assertEquals((Object)domainRange.getLowerBound(), (Object)roundTrippedDomainRange.getLowerBound());
        Assertions.assertEquals((Object)domainRange.getUpperBound(), (Object)roundTrippedDomainRange.getUpperBound());
    }

    @Test
    public void testCounterfactualSearchDomain_Categorical_RoundTrip() throws Exception {
        CounterfactualDomainCategorical domainCategorical = new CounterfactualDomainCategorical(List.of(new TextNode("A"), new TextNode("B")));
        CounterfactualSearchDomain searchDomain = new CounterfactualSearchDomain("age", (CounterfactualSearchDomainValue)new CounterfactualSearchDomainUnitValue("integer", "integer", Boolean.TRUE, (CounterfactualDomain)domainCategorical));
        this.mapper.writeValue((Writer)this.writer, (Object)searchDomain);
        String searchDomainJson = this.writer.toString();
        Assertions.assertNotNull((Object)searchDomainJson);
        CounterfactualSearchDomain roundTrippedSearchDomain = (CounterfactualSearchDomain)this.mapper.readValue(searchDomainJson, CounterfactualSearchDomain.class);
        Assertions.assertTrue((boolean)(roundTrippedSearchDomain.getValue() instanceof CounterfactualSearchDomainUnitValue));
        Assertions.assertEquals((Object)searchDomain.getValue().getKind(), (Object)roundTrippedSearchDomain.getValue().getKind());
        Assertions.assertEquals((Object)searchDomain.getName(), (Object)roundTrippedSearchDomain.getName());
        Assertions.assertEquals((Object)searchDomain.getValue().getType(), (Object)roundTrippedSearchDomain.getValue().getType());
        Assertions.assertEquals((Object)((CounterfactualSearchDomainUnitValue)searchDomain.getValue().toUnit()).getBaseType(), (Object)((CounterfactualSearchDomainUnitValue)roundTrippedSearchDomain.getValue().toUnit()).getBaseType());
        Assertions.assertEquals((Object)((CounterfactualSearchDomainUnitValue)searchDomain.getValue().toUnit()).isFixed(), (Object)((CounterfactualSearchDomainUnitValue)roundTrippedSearchDomain.getValue().toUnit()).isFixed());
        Assertions.assertTrue((boolean)(((CounterfactualSearchDomainUnitValue)roundTrippedSearchDomain.getValue().toUnit()).getDomain() instanceof CounterfactualDomainCategorical));
        CounterfactualDomainCategorical roundTrippedDomainCategorical = (CounterfactualDomainCategorical)((CounterfactualSearchDomainUnitValue)roundTrippedSearchDomain.getValue().toUnit()).getDomain();
        Assertions.assertEquals((int)domainCategorical.getCategories().size(), (int)roundTrippedDomainCategorical.getCategories().size());
        Assertions.assertTrue((boolean)roundTrippedDomainCategorical.getCategories().containsAll(domainCategorical.getCategories()));
    }
}

