/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.storage.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import org.kie.kogito.KogitoGAV;
import org.kie.kogito.ModelDomain;
import org.kie.kogito.trusty.storage.api.model.decision.DMNModelMetadata;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="@type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=DMNModelMetadata.class, name="DECISION")})
@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class ModelMetadata {
    private static final String IDENTIFIER_TEMPLATE = "%s:%s";
    public static final String GROUP_ID_FIELD = "groupId";
    public static final String ARTIFACT_ID_FIELD = "artifactId";
    public static final String MODEL_VERSION_FIELD = "modelVersion";
    @JsonProperty(value="groupId")
    private String groupId;
    @JsonProperty(value="artifactId")
    private String artifactId;
    @JsonProperty(value="modelVersion")
    private String modelVersion;
    @JsonProperty(value="@type")
    private ModelDomain modelDomain;

    protected ModelMetadata() {
    }

    protected ModelMetadata(String groupId, String artifactId, String modelVersion, ModelDomain modelDomain) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.modelVersion = modelVersion;
        this.modelDomain = modelDomain;
    }

    protected ModelMetadata(KogitoGAV gav, ModelDomain modelDomain) {
        this(gav.getGroupId(), gav.getArtifactId(), gav.getVersion(), modelDomain);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    public abstract String getIdentifier();

    protected String makeIdentifier(String leftPart, String rightPart) {
        return String.format(IDENTIFIER_TEMPLATE, this.nullable(leftPart), this.nullable(rightPart));
    }

    private String nullable(String value) {
        return Objects.isNull(value) ? "" : value;
    }
}

