/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.storage.common;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.kogito.explainability.api.CounterfactualExplainabilityRequest;
import org.kie.kogito.explainability.api.CounterfactualExplainabilityResult;
import org.kie.kogito.explainability.api.LIMEExplainabilityResult;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.StorageService;
import org.kie.kogito.trusty.storage.api.model.ModelMetadata;
import org.kie.kogito.trusty.storage.api.model.ModelWithMetadata;
import org.kie.kogito.trusty.storage.api.model.decision.Decision;
import org.kie.kogito.trusty.storage.common.TrustyStorageService;

@ApplicationScoped
public class TrustyStorageServiceImpl
implements TrustyStorageService {
    @Inject
    StorageService storageService;

    @Override
    public Storage<String, Decision> getDecisionsStorage() {
        return this.storageService.getCache("decisions", Decision.class);
    }

    @Override
    public Storage<String, LIMEExplainabilityResult> getLIMEResultStorage() {
        return this.storageService.getCache("limeResults", LIMEExplainabilityResult.class);
    }

    @Override
    public <T extends ModelMetadata, E extends ModelWithMetadata<T>> Storage<String, E> getModelStorage(Class<E> modelWithMetadata) {
        return this.storageService.getCache("models", modelWithMetadata);
    }

    @Override
    public Storage<String, CounterfactualExplainabilityRequest> getCounterfactualRequestStorage() {
        return this.storageService.getCache("counterfactualRequests", CounterfactualExplainabilityRequest.class);
    }

    @Override
    public Storage<String, CounterfactualExplainabilityResult> getCounterfactualResultStorage() {
        return this.storageService.getCache("counterfactualResults", CounterfactualExplainabilityResult.class);
    }
}

