/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.axle;

import io.smallrye.mutiny.helpers.Subscriptions;
import io.vertx.core.Handler;
import io.vertx.core.streams.ReadStream;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class PublisherReadStream<T, U>
implements Publisher<U> {
    public static final long DEFAULT_MAX_BUFFER_SIZE = 256L;
    private final ReadStream<T> stream;
    private final Function<T, U> f;
    private final AtomicReference<Subscription> current;

    public PublisherReadStream(ReadStream<T> stream, Function<T, U> f) {
        stream.pause();
        this.stream = stream;
        this.f = f;
        this.current = new AtomicReference();
    }

    private void release() {
        Subscription sub = this.current.get();
        if (sub != null && this.current.compareAndSet(sub, null)) {
            try {
                this.stream.exceptionHandler((Handler)null);
                this.stream.endHandler(null);
                this.stream.handler(null);
            }
            catch (Exception exception) {
            }
            finally {
                this.stream.resume();
            }
        }
    }

    @Override
    public void subscribe(Subscriber<? super U> subscriber) {
        Subscription sub = new Subscription(){

            @Override
            public void request(long l) {
                if (PublisherReadStream.this.current.get() == this) {
                    PublisherReadStream.this.stream.fetch(l);
                }
            }

            @Override
            public void cancel() {
                PublisherReadStream.this.release();
            }
        };
        if (!this.current.compareAndSet(null, sub)) {
            Subscriptions.fail(subscriber, new IllegalStateException("This processor allows only a single Subscriber"));
            return;
        }
        this.stream.pause();
        this.stream.endHandler(v -> {
            this.release();
            subscriber.onComplete();
        });
        this.stream.exceptionHandler(err -> {
            this.release();
            subscriber.onError((Throwable)err);
        });
        this.stream.handler(item -> subscriber.onNext(this.f.apply(item)));
        subscriber.onSubscribe(sub);
    }
}

