/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.ThreadPoolConfig;
import io.quarkus.runtime.annotations.Recorder;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.jboss.threads.ContextHandler;
import org.jboss.threads.EnhancedQueueExecutor;
import org.jboss.threads.JBossExecutors;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.common.cpu.ProcessorInfo;

@Recorder
public class ExecutorRecorder {
    private static final Logger log = Logger.getLogger("io.quarkus.thread-pool");
    private static volatile Executor current;

    public ExecutorService setupRunTime(ShutdownContext shutdownContext, ThreadPoolConfig threadPoolConfig, LaunchMode launchMode, ThreadFactory threadFactory, ContextHandler<Object> contextHandler) {
        final EnhancedQueueExecutor underlying = ExecutorRecorder.createExecutor(threadPoolConfig, threadFactory, contextHandler);
        if (launchMode == LaunchMode.DEVELOPMENT) {
            shutdownContext.addLastShutdownTask(new Runnable(){

                @Override
                public void run() {
                    for (Runnable i : underlying.shutdownNow()) {
                        Thread thread = new Thread(i, "Shutdown task thread");
                        thread.setDaemon(true);
                        thread.start();
                    }
                    current = null;
                }
            });
        } else {
            Runnable shutdownTask = ExecutorRecorder.createShutdownTask(threadPoolConfig, underlying);
            shutdownContext.addLastShutdownTask(shutdownTask);
        }
        if (threadPoolConfig.prefill) {
            underlying.prestartAllCoreThreads();
        }
        current = underlying;
        return underlying;
    }

    private static Runnable createShutdownTask(final ThreadPoolConfig threadPoolConfig, final EnhancedQueueExecutor executor) {
        return new Runnable(){

            @Override
            public void run() {
                long interval;
                executor.shutdown();
                Duration shutdownTimeout = threadPoolConfig.shutdownTimeout;
                Optional<Duration> optionalInterval = threadPoolConfig.shutdownCheckInterval;
                long remaining = shutdownTimeout.toNanos();
                long intervalRemaining = interval = optionalInterval.orElse(Duration.ofNanos(Long.MAX_VALUE)).toNanos();
                long interruptRemaining = threadPoolConfig.shutdownInterrupt.toNanos();
                long start = System.nanoTime();
                int loop = 1;
                while (true) {
                    log.debugf("loop: %s, remaining: %s, intervalRemaining: %s, interruptRemaining: %s", loop++, remaining, intervalRemaining, interruptRemaining);
                    try {
                        if (!executor.awaitTermination(Math.min(remaining, intervalRemaining), TimeUnit.NANOSECONDS)) {
                            long elapsed = System.nanoTime() - start;
                            intervalRemaining -= elapsed;
                            remaining -= elapsed;
                            if ((interruptRemaining -= elapsed) <= 0L) {
                                executor.shutdown(true);
                            }
                            if (remaining <= 0L) {
                                List<Runnable> runnables = executor.shutdownNow();
                                if (!runnables.isEmpty()) {
                                    log.warnf("Thread pool shutdown failed: discarding %d tasks, %d threads still running", (Object)runnables.size(), (Object)executor.getActiveCount());
                                } else {
                                    log.warnf("Thread pool shutdown failed: %d threads still running", (Object)executor.getActiveCount());
                                }
                            } else {
                                if (intervalRemaining > 0L) continue;
                                intervalRemaining = interval;
                                int queueSize = executor.getQueueSize();
                                Thread[] runningThreads = executor.getRunningThreads();
                                log.infof("Awaiting thread pool shutdown; %d thread(s) running with %d task(s) waiting", (Object)runningThreads.length, (Object)queueSize);
                                int realWaiting = runningThreads.length;
                                block3: for (Thread thr : runningThreads) {
                                    StackTraceElement[] stackTrace = thr.getStackTrace();
                                    for (int i = 0; i < stackTrace.length && i < 8; ++i) {
                                        if (!stackTrace[i].getClassName().equals("java.lang.System") || !stackTrace[i].getMethodName().equals("exit")) continue;
                                        Throwable t = new Throwable();
                                        t.setStackTrace(stackTrace);
                                        log.errorf(t, "Thread %s is blocked in System.exit(); pooled (Executor) threads should never call this method because it never returns, thus preventing the thread pool from shutting down in a timely manner.  This is the stack trace of the call", (Object)thr.getName());
                                        --realWaiting;
                                        continue block3;
                                    }
                                }
                                if (realWaiting != 0 || queueSize != 0) continue;
                                executor.shutdownNow();
                            }
                            break;
                        }
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        };
    }

    private static EnhancedQueueExecutor createExecutor(ThreadPoolConfig threadPoolConfig, ThreadFactory threadFactory, ContextHandler<Object> contextHandler) {
        if (threadFactory == null) {
            threadFactory = new JBossThreadFactory(new ThreadGroup("executor"), Boolean.TRUE, null, "executor-thread-%t", JBossExecutors.loggingExceptionHandler("org.jboss.executor.uncaught"), null);
        }
        EnhancedQueueExecutor.Builder builder = new EnhancedQueueExecutor.Builder().setRegisterMBean(false).setHandoffExecutor(JBossExecutors.rejectingExecutor()).setThreadFactory(JBossExecutors.resettingThreadFactory(threadFactory));
        int cpus = ProcessorInfo.availableProcessors();
        builder.setCorePoolSize(threadPoolConfig.coreThreads);
        builder.setMaximumPoolSize(threadPoolConfig.maxThreads.orElse(Math.max(8 * cpus, 200)));
        if (threadPoolConfig.queueSize.isPresent()) {
            if (threadPoolConfig.queueSize.getAsInt() < 0) {
                builder.setMaximumQueueSize(Integer.MAX_VALUE);
            } else {
                builder.setMaximumQueueSize(threadPoolConfig.queueSize.getAsInt());
            }
        }
        builder.setGrowthResistance(threadPoolConfig.growthResistance);
        builder.setKeepAliveTime(threadPoolConfig.keepAliveTime);
        if (contextHandler != null) {
            builder.setContextHandler(contextHandler);
        }
        return builder.build();
    }

    public static Executor getCurrent() {
        return current;
    }
}

