/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.runtime.TemplateHtmlBuilder;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.ForbiddenException;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class QuarkusErrorHandler
implements Handler<RoutingContext> {
    private static final Logger log = Logger.getLogger(QuarkusErrorHandler.class);
    private static final String BASE_ID = UUID.randomUUID().toString() + "-";
    private static final AtomicLong ERROR_COUNT = new AtomicLong();
    private final boolean showStack;

    public QuarkusErrorHandler(boolean showStack) {
        this.showStack = showStack;
    }

    @Override
    public void handle(final RoutingContext event) {
        try {
            if (event.failure() == null) {
                event.response().setStatusCode(event.statusCode());
                event.response().end();
                return;
            }
            if (event.failure() instanceof UnauthorizedException) {
                HttpAuthenticator authenticator = (HttpAuthenticator)event.get(HttpAuthenticator.class.getName());
                if (authenticator != null) {
                    authenticator.sendChallenge(event).subscribe().with(new Consumer<Boolean>(){

                        @Override
                        public void accept(Boolean aBoolean) {
                            event.response().end();
                        }
                    }, new Consumer<Throwable>(){

                        @Override
                        public void accept(Throwable throwable) {
                            event.fail(throwable);
                        }
                    });
                } else {
                    event.response().setStatusCode(HttpResponseStatus.UNAUTHORIZED.code()).end();
                }
                return;
            }
            if (event.failure() instanceof ForbiddenException) {
                event.response().setStatusCode(HttpResponseStatus.FORBIDDEN.code()).end();
                return;
            }
            if (event.failure() instanceof AuthenticationFailedException) {
                event.response().setStatusCode(HttpResponseStatus.UNAUTHORIZED.code()).end();
                return;
            }
        }
        catch (IllegalStateException e) {
            if (!event.response().ended()) {
                event.response().end();
            }
            return;
        }
        if (!event.response().headWritten()) {
            event.response().setStatusCode(event.statusCode() > 0 ? event.statusCode() : 500);
        }
        String uuid = BASE_ID + ERROR_COUNT.incrementAndGet();
        Object details = "";
        String stack = "";
        Throwable exception = event.failure();
        if (this.showStack && exception != null) {
            details = QuarkusErrorHandler.generateHeaderMessage(exception, uuid);
            stack = QuarkusErrorHandler.generateStackTrace(exception);
        } else {
            details = (String)details + "Error id " + uuid;
        }
        if (event.failure() instanceof IOException) {
            log.debugf(exception, "IOError processing HTTP request to %s failed, the client likely terminated the connection. Error id: %s", (Object)event.request().uri(), (Object)uuid);
        } else {
            log.errorf(exception, "HTTP Request to %s failed, error id: %s", (Object)event.request().uri(), (Object)uuid);
        }
        if (event.response().ended()) {
            return;
        }
        if (event.response().headWritten()) {
            event.response().end();
            return;
        }
        String accept = event.request().getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            event.response().headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json; charset=utf-8");
            String escapedDetails = QuarkusErrorHandler.escapeJsonString((String)details);
            String escapedStack = QuarkusErrorHandler.escapeJsonString(stack);
            StringBuilder jsonPayload = new StringBuilder("{\"details\":\"").append(escapedDetails).append("\",\"stack\":\"").append(escapedStack).append("\"}");
            this.writeResponse(event, jsonPayload.toString());
        } else {
            event.response().headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"text/html; charset=utf-8");
            TemplateHtmlBuilder htmlBuilder = new TemplateHtmlBuilder("Internal Server Error", (String)details, (String)details);
            if (this.showStack && exception != null) {
                htmlBuilder.stack(exception);
            }
            this.writeResponse(event, htmlBuilder.toString());
        }
    }

    private void writeResponse(RoutingContext event, String output) {
        if (!event.response().ended()) {
            event.response().end(output);
        }
    }

    private static String generateStackTrace(Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString().trim();
    }

    private static String generateHeaderMessage(Throwable exception, String uuid) {
        return String.format("Error handling %s, %s: %s", uuid, exception.getClass().getName(), QuarkusErrorHandler.extractFirstLine(exception.getMessage()));
    }

    private static String extractFirstLine(String message) {
        if (null == message) {
            return "";
        }
        String[] lines = message.split("\\r?\\n");
        return lines[0].trim();
    }

    static String escapeJsonString(String text) {
        StringBuilder sb = new StringBuilder();
        block9: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

