/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import javax.annotation.Priority;
import javax.enterprise.inject.spi.CDI;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
@Priority(value=5001)
public class AuthenticationFailedExceptionMapper
implements ExceptionMapper<AuthenticationFailedException> {
    private volatile CurrentVertxRequest currentVertxRequest;

    CurrentVertxRequest currentVertxRequest() {
        if (this.currentVertxRequest == null) {
            this.currentVertxRequest = (CurrentVertxRequest)CDI.current().select(CurrentVertxRequest.class, new Annotation[0]).get();
        }
        return this.currentVertxRequest;
    }

    @Override
    public Response toResponse(AuthenticationFailedException exception) {
        HttpAuthenticator authenticator;
        RoutingContext context = this.currentVertxRequest().getCurrent();
        if (context != null && (authenticator = (HttpAuthenticator)context.get(HttpAuthenticator.class.getName())) != null) {
            ChallengeData challengeData = authenticator.getChallenge(context).await().indefinitely();
            Response.ResponseBuilder status = Response.status(challengeData.status);
            if (challengeData.headerName != null) {
                status.header(challengeData.headerName.toString(), challengeData.headerContent);
            }
            return status.build();
        }
        return Response.status(401).entity("Not Authenticated").build();
    }
}

