/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni.builders;

import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class UniCreateFromPublisher<T>
extends AbstractUni<T> {
    private final Publisher<? extends T> publisher;

    public UniCreateFromPublisher(Publisher<? extends T> publisher) {
        this.publisher = ParameterValidation.nonNull(publisher, "publisher");
    }

    @Override
    public void subscribe(UniSubscriber<? super T> subscriber) {
        new PublisherSubscriber(subscriber).forward();
    }

    private class PublisherSubscriber
    implements UniSubscription,
    Subscriber<T> {
        private final UniSubscriber<? super T> subscriber;
        AtomicReference<Subscription> subscription = new AtomicReference();

        private PublisherSubscriber(UniSubscriber<? super T> subscriber) {
            this.subscriber = subscriber;
        }

        private void forward() {
            this.subscriber.onSubscribe(this);
            Subscriber sub = Infrastructure.onMultiSubscription(UniCreateFromPublisher.this.publisher, this);
            UniCreateFromPublisher.this.publisher.subscribe(sub);
        }

        @Override
        public void cancel() {
            Subscription old = this.subscription.getAndSet(EmptyUniSubscription.CANCELLED);
            if (old != null) {
                old.cancel();
            }
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (this.subscription.compareAndSet(null, s)) {
                s.request(1L);
            } else {
                s.cancel();
            }
        }

        @Override
        public void onNext(T item) {
            Subscription sub = this.subscription.getAndSet(EmptyUniSubscription.CANCELLED);
            if (sub != EmptyUniSubscription.CANCELLED) {
                sub.cancel();
                this.subscriber.onItem(item);
            }
        }

        @Override
        public void onError(Throwable failure) {
            Subscription sub = this.subscription.getAndSet(EmptyUniSubscription.CANCELLED);
            if (sub != EmptyUniSubscription.CANCELLED) {
                this.subscriber.onFailure(failure);
            }
        }

        @Override
        public void onComplete() {
            Subscription sub = this.subscription.getAndSet(EmptyUniSubscription.CANCELLED);
            if (sub != EmptyUniSubscription.CANCELLED) {
                this.subscriber.onItem(null);
            }
        }
    }
}

