/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.principal;

import io.smallrye.jwt.KeyFormat;
import io.smallrye.jwt.algorithm.SignatureAlgorithm;
import io.smallrye.jwt.auth.principal.AbstractKeyLocationResolver;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.auth.principal.PrincipalLogging;
import io.smallrye.jwt.util.KeyUtils;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.List;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.UnresolvableKeyException;

public class KeyLocationResolver
extends AbstractKeyLocationResolver
implements VerificationKeyResolver {
    public KeyLocationResolver(JWTAuthContextInfo authContextInfo) throws UnresolvableKeyException {
        super(authContextInfo);
        try {
            this.initializeKeyContent();
        }
        catch (Exception e) {
            KeyLocationResolver.reportLoadKeyException(authContextInfo.getPublicKeyContent(), authContextInfo.getPublicKeyLocation(), e);
        }
    }

    @Override
    public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        KeyLocationResolver.verifyKid(jws, this.authContextInfo.getTokenKeyId());
        if (this.key != null) {
            return this.key;
        }
        Key theKey = this.tryAsVerificationJwk(jws);
        if (theKey == null) {
            KeyLocationResolver.reportUnresolvableKeyException(this.authContextInfo.getPublicKeyContent(), this.authContextInfo.getPublicKeyLocation());
        }
        return theKey;
    }

    private Key tryAsVerificationJwk(JsonWebSignature jws) throws UnresolvableKeyException {
        JsonWebKey jwk = super.tryAsJwk(jws, this.authContextInfo.getSignatureAlgorithm().getAlgorithm());
        return this.fromJwkToVerificationKey(jwk);
    }

    private Key fromJwkToVerificationKey(JsonWebKey jwk) {
        Key theKey = null;
        if (jwk != null && (theKey = this.getSecretKeyFromJwk(jwk)) == null) {
            theKey = ((PublicJsonWebKey)PublicJsonWebKey.class.cast(jwk)).getPublicKey();
        }
        return theKey;
    }

    protected void initializeKeyContent() throws Exception {
        String content;
        if (this.isHttpsJwksInitialized(this.authContextInfo.getPublicKeyLocation())) {
            return;
        }
        String string = content = this.authContextInfo.getPublicKeyContent() != null ? this.authContextInfo.getPublicKeyContent() : this.readKeyContent(this.authContextInfo.getPublicKeyLocation());
        if (this.mayBeFormat(KeyFormat.PEM_KEY)) {
            this.key = KeyLocationResolver.tryAsPEMPublicKey(content, this.authContextInfo.getSignatureAlgorithm());
            if (this.key != null || this.isFormat(KeyFormat.PEM_KEY)) {
                return;
            }
        }
        if (this.mayBeFormat(KeyFormat.PEM_CERTIFICATE)) {
            this.key = this.tryAsPEMCertificate(content);
            if (this.key != null || this.isFormat(KeyFormat.PEM_CERTIFICATE)) {
                return;
            }
        }
        JsonWebKey jwk = this.loadFromJwk(content, this.authContextInfo.getTokenKeyId(), this.authContextInfo.getSignatureAlgorithm().getAlgorithm());
        this.key = this.fromJwkToVerificationKey(jwk);
    }

    static PublicKey tryAsPEMPublicKey(String content, SignatureAlgorithm algo) {
        PrincipalLogging.log.checkKeyContentIsBase64EncodedPEMKey();
        PublicKey key = null;
        try {
            key = KeyUtils.decodePublicKey(content, algo);
            PrincipalLogging.log.keyCreatedFromEncodedPEMKey();
        }
        catch (Exception e) {
            PrincipalLogging.log.keyContentIsNotValidEncodedPEMKey(e);
        }
        return key;
    }

    PublicKey tryAsPEMCertificate(String content) {
        X509Certificate cert = super.loadPEMCertificate(content);
        return cert == null ? null : cert.getPublicKey();
    }
}

