/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.web.runtime;

import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.web.runtime.RouteHandler;
import io.quarkus.vertx.web.runtime.RouteMatcher;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Function;

@Recorder
public class VertxWebRecorder {
    public Handler<RoutingContext> createHandler(String handlerClassName) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = VertxWebRecorder.class.getClassLoader();
            }
            Class<?> handlerClazz = cl.loadClass(handlerClassName);
            RouteHandler handler = (RouteHandler)handlerClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return handler;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create route handler: " + handlerClassName, e);
        }
    }

    public Function<Router, Route> createRouteFunction(final RouteMatcher matcher, final Handler<RoutingContext> bodyHandler) {
        return new Function<Router, Route>(){

            @Override
            public Route apply(Router router) {
                Route route = matcher.getRegex() != null && !matcher.getRegex().isEmpty() ? router.routeWithRegex(matcher.getRegex()) : (matcher.getPath() != null && !matcher.getPath().isEmpty() ? router.route(matcher.getPath()) : router.route());
                if (matcher.getMethods().length > 0) {
                    for (String method : matcher.getMethods()) {
                        route.method(HttpMethod.valueOf(method));
                    }
                }
                if (matcher.getOrder() > 0) {
                    route.order(matcher.getOrder());
                }
                if (matcher.getProduces().length > 0) {
                    for (String produces : matcher.getProduces()) {
                        route.produces(produces);
                    }
                }
                if (matcher.getConsumes().length > 0) {
                    for (String consumes : matcher.getConsumes()) {
                        route.consumes(consumes);
                    }
                }
                if (bodyHandler != null) {
                    route.handler(bodyHandler);
                }
                return route;
            }
        };
    }
}

