/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc;

import io.quarkus.oidc.RefreshToken;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.security.credential.TokenCredential;

public class AccessTokenCredential
extends TokenCredential {
    private RefreshToken refreshToken;
    private boolean opaque;

    public AccessTokenCredential() {
        this(null);
    }

    public AccessTokenCredential(String accessToken) {
        this(accessToken, (RefreshToken)null);
    }

    public AccessTokenCredential(String accessToken, RefreshToken refreshToken) {
        super(accessToken, "bearer");
        this.refreshToken = refreshToken;
        if (accessToken != null) {
            this.opaque = OidcUtils.isOpaqueToken(accessToken);
        }
    }

    public RefreshToken getRefreshToken() {
        return this.refreshToken;
    }

    public boolean isOpaque() {
        return this.opaque;
    }
}

