/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.EvalContext;
import java.util.Objects;

final class MemberKey {
    final Class<?> clazz;
    final String name;
    final int numberOfParams;
    final int hashCode;

    MemberKey(Class<?> clazz, String name, int numberOfParams) {
        this.clazz = clazz;
        this.name = name;
        this.numberOfParams = numberOfParams;
        int prime = 31;
        int result = 1;
        result = 31 * result + clazz.hashCode();
        result = 31 * result + name.hashCode();
        this.hashCode = result = 31 * result + numberOfParams;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemberKey other = (MemberKey)obj;
        return Objects.equals(this.clazz, other.clazz) && Objects.equals(this.name, other.name) && this.numberOfParams == other.numberOfParams;
    }

    public String toString() {
        return String.format("MemberKey [clazz: %s, name: %s, numberOfParams: %s]", this.clazz, this.name, this.numberOfParams);
    }

    static MemberKey from(EvalContext context) {
        Class clazz;
        Object contextObject = context.getBase();
        String name = context.getName();
        Class baseClass = contextObject.getClass();
        if (contextObject instanceof Class && (clazz = (Class)contextObject).isEnum() && ("values".equals(name) || MemberKey.isConstantName(clazz, name))) {
            baseClass = clazz;
        }
        return new MemberKey(baseClass, name, context.getParams().size());
    }

    private static boolean isConstantName(Class<?> enumClazz, String name) {
        for (Object constant : enumClazz.getEnumConstants()) {
            if (!name.equals(constant.toString())) continue;
            return true;
        }
        return false;
    }
}

