/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class ConfigurableConfigSource
implements ConfigSource {
    private final ConfigSourceFactory factory;

    public ConfigurableConfigSource(ConfigSourceFactory factory) {
        this.factory = factory;
    }

    @Override
    public Map<String, String> getProperties() {
        return new HashMap<String, String>();
    }

    @Override
    public Set<String> getPropertyNames() {
        return new HashSet<String>();
    }

    @Override
    public String getValue(String propertyName) {
        return null;
    }

    @Override
    public String getName() {
        return this.factory.getClass().getName();
    }

    @Override
    public int getOrdinal() {
        return this.factory.getPriority().orElse(100);
    }

    ConfigSourceFactory getFactory() {
        return this.factory;
    }

    List<ConfigSource> getConfigSources(ConfigSourceContext context) {
        return this.unwrap(context, new ArrayList<ConfigSource>());
    }

    private List<ConfigSource> unwrap(ConfigSourceContext context, List<ConfigSource> configSources) {
        for (ConfigSource configSource : this.factory.getConfigSources(context)) {
            if (configSource instanceof ConfigurableConfigSource) {
                configSources.addAll(((ConfigurableConfigSource)configSource).getConfigSources(context));
                continue;
            }
            configSources.add(configSource);
        }
        return configSources;
    }
}

