/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl.cache;

import io.netty.handler.codec.DateFormatter;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.client.impl.cache.CacheControlDirective;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class CacheControl {
    private final Set<CacheControlDirective> directives = new HashSet<CacheControlDirective>();
    private final Map<CacheControlDirective, Long> timeDirectives = new HashMap<CacheControlDirective, Long>();
    private final Instant expires;
    private final Instant date;
    private final String etag;
    private final String vary;
    private final long maxAge;

    static CacheControl parse(MultiMap headers) {
        return new CacheControl(headers);
    }

    private CacheControl(MultiMap headers) {
        this.etag = headers.get(HttpHeaders.ETAG);
        this.vary = headers.get(HttpHeaders.VARY);
        this.date = headers.contains(HttpHeaders.DATE) ? DateFormatter.parseHttpDate(headers.get(HttpHeaders.DATE)).toInstant() : Instant.now();
        this.expires = headers.contains(HttpHeaders.EXPIRES) ? DateFormatter.parseHttpDate(headers.get(HttpHeaders.EXPIRES)).toInstant() : null;
        this.parseAllCacheControl(headers);
        this.maxAge = this.computeMaxAge();
    }

    public Set<CacheControlDirective> getDirectives() {
        return this.directives;
    }

    public Map<CacheControlDirective, Long> getTimeDirectives() {
        return this.timeDirectives;
    }

    public String getEtag() {
        return this.etag;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public Set<CharSequence> variations() {
        if (this.vary == null) {
            return Collections.emptySet();
        }
        HashSet<CharSequence> variations = new HashSet<CharSequence>();
        String remaining = this.vary;
        int nextDelim = remaining.indexOf(44);
        while (nextDelim > 0) {
            variations.add(HttpHeaders.createOptimized(remaining.substring(0, nextDelim).trim().toLowerCase()));
            remaining = remaining.substring(nextDelim + 1);
            nextDelim = remaining.indexOf(44);
        }
        if (!remaining.isEmpty()) {
            variations.add(HttpHeaders.createOptimized(remaining.trim().toLowerCase()));
        }
        return variations;
    }

    public boolean isCacheable() {
        if (this.directives.contains((Object)CacheControlDirective.NO_STORE)) {
            return false;
        }
        if ("*".equals(this.vary)) {
            return false;
        }
        return this.maxAge > 0L;
    }

    public boolean isPublic() {
        return this.directives.contains((Object)CacheControlDirective.PUBLIC) && !this.isPrivate();
    }

    public boolean isPrivate() {
        return this.directives.contains((Object)CacheControlDirective.PRIVATE);
    }

    public boolean isVarying() {
        return !this.variations().isEmpty();
    }

    public boolean noStore() {
        return this.directives.contains((Object)CacheControlDirective.NO_STORE);
    }

    public boolean noCache() {
        return !this.noStore() && this.directives.contains((Object)CacheControlDirective.NO_CACHE);
    }

    public boolean mustRevalidate() {
        return this.directives.contains((Object)CacheControlDirective.MUST_REVALIDATE);
    }

    private long computeMaxAge() {
        if (!this.isPrivate() && this.timeDirectives.containsKey((Object)CacheControlDirective.SHARED_MAX_AGE)) {
            return this.timeDirectives.get((Object)CacheControlDirective.SHARED_MAX_AGE);
        }
        if (this.timeDirectives.containsKey((Object)CacheControlDirective.MAX_AGE)) {
            return this.timeDirectives.get((Object)CacheControlDirective.MAX_AGE);
        }
        if (this.expires != null) {
            return Duration.between(this.date, this.expires).getSeconds();
        }
        return Long.MAX_VALUE;
    }

    private void parseAllCacheControl(MultiMap headers) {
        headers.getAll(HttpHeaders.CACHE_CONTROL).forEach(value -> {
            for (String headerDirectives : value.split(",")) {
                String[] directiveParts = headerDirectives.split("=", 2);
                Optional<CacheControlDirective> directive = CacheControlDirective.fromHeader(directiveParts[0].trim().toLowerCase());
                if (!directive.isPresent()) continue;
                if (directiveParts.length == 1) {
                    this.directives.add(directive.get());
                    continue;
                }
                try {
                    this.timeDirectives.put(directive.get(), Long.parseLong(directiveParts[1].replaceAll("\"", "").trim().toLowerCase()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
    }
}

