/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.quarkus.vertx.http.runtime.ForwardedParser;
import io.quarkus.vertx.http.runtime.ForwardingProxyOptions;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

class ForwardedServerRequestWrapper
implements HttpServerRequest {
    private final HttpServerRequest delegate;
    private final ForwardedParser forwardedParser;
    private boolean modified;
    private HttpMethod method;
    private String path;
    private String query;
    private String uri;
    private String absoluteURI;

    ForwardedServerRequestWrapper(HttpServerRequest request, ForwardingProxyOptions forwardingProxyOptions) {
        this.delegate = request;
        this.forwardedParser = new ForwardedParser(this.delegate, forwardingProxyOptions);
    }

    void changeTo(HttpMethod method, String uri) {
        this.modified = true;
        this.method = method;
        this.uri = uri;
        this.path = null;
        this.query = null;
        this.absoluteURI = null;
        int queryIndex = uri.indexOf(63);
        int fragmentIndex = uri.indexOf(35);
        if (queryIndex != -1) {
            this.path = uri.substring(0, queryIndex);
            this.query = fragmentIndex != -1 ? uri.substring(queryIndex + 1, fragmentIndex) : uri.substring(queryIndex + 1);
        } else {
            this.path = fragmentIndex != -1 ? uri.substring(0, fragmentIndex) : uri;
        }
    }

    @Override
    public long bytesRead() {
        return this.delegate.bytesRead();
    }

    @Override
    public HttpServerRequest exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler((Handler)handler);
        return this;
    }

    @Override
    public HttpServerRequest handler(Handler<Buffer> handler) {
        this.delegate.handler((Handler)handler);
        return this;
    }

    @Override
    public HttpServerRequest pause() {
        this.delegate.pause();
        return this;
    }

    @Override
    public HttpServerRequest resume() {
        this.delegate.resume();
        return this;
    }

    @Override
    public HttpServerRequest fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Override
    public HttpServerRequest endHandler(Handler<Void> handler) {
        this.delegate.endHandler((Handler)handler);
        return this;
    }

    @Override
    public HttpVersion version() {
        return this.delegate.version();
    }

    @Override
    public HttpMethod method() {
        if (!this.modified) {
            return this.delegate.method();
        }
        return this.method;
    }

    @Override
    public String rawMethod() {
        if (!this.modified) {
            return this.delegate.rawMethod();
        }
        return this.method.toString();
    }

    @Override
    public String uri() {
        if (!this.modified) {
            return this.forwardedParser.uri();
        }
        return this.uri;
    }

    @Override
    public String path() {
        if (!this.modified) {
            return this.delegate.path();
        }
        return this.path;
    }

    @Override
    public String query() {
        if (!this.modified) {
            return this.delegate.query();
        }
        return this.query;
    }

    @Override
    public HttpServerResponse response() {
        return this.delegate.response();
    }

    @Override
    public MultiMap headers() {
        return this.delegate.headers();
    }

    @Override
    public String getHeader(String s) {
        return this.delegate.getHeader(s);
    }

    @Override
    public String getHeader(CharSequence charSequence) {
        return this.delegate.getHeader(charSequence);
    }

    @Override
    public MultiMap params() {
        return this.delegate.params();
    }

    @Override
    public String getParam(String s) {
        return this.delegate.getParam(s);
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.forwardedParser.remoteAddress();
    }

    @Override
    public SocketAddress localAddress() {
        return this.delegate.localAddress();
    }

    @Override
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.delegate.peerCertificateChain();
    }

    @Override
    public SSLSession sslSession() {
        return this.delegate.sslSession();
    }

    @Override
    public String absoluteURI() {
        if (!this.modified) {
            return this.forwardedParser.absoluteURI();
        }
        if (this.absoluteURI == null) {
            String scheme = this.forwardedParser.scheme();
            String host = this.forwardedParser.host();
            this.absoluteURI = scheme != null && host != null ? scheme + "://" + host + this.uri : this.uri;
        }
        return this.absoluteURI;
    }

    @Override
    public String scheme() {
        return this.forwardedParser.scheme();
    }

    @Override
    public String host() {
        return this.forwardedParser.host();
    }

    @Override
    public HttpServerRequest customFrameHandler(Handler<HttpFrame> handler) {
        this.delegate.customFrameHandler(handler);
        return this;
    }

    @Override
    public HttpConnection connection() {
        return this.delegate.connection();
    }

    @Override
    public HttpServerRequest bodyHandler(Handler<Buffer> handler) {
        this.delegate.bodyHandler(handler);
        return this;
    }

    @Override
    public NetSocket netSocket() {
        return this.delegate.netSocket();
    }

    @Override
    public HttpServerRequest setExpectMultipart(boolean b) {
        this.delegate.setExpectMultipart(b);
        return this;
    }

    @Override
    public boolean isExpectMultipart() {
        return this.delegate.isExpectMultipart();
    }

    @Override
    public HttpServerRequest uploadHandler(Handler<HttpServerFileUpload> handler) {
        this.delegate.uploadHandler(handler);
        return this;
    }

    @Override
    public MultiMap formAttributes() {
        return this.delegate.formAttributes();
    }

    @Override
    public String getFormAttribute(String s) {
        return this.delegate.getFormAttribute(s);
    }

    @Override
    public ServerWebSocket upgrade() {
        return this.delegate.upgrade();
    }

    @Override
    public boolean isEnded() {
        return this.delegate.isEnded();
    }

    @Override
    public boolean isSSL() {
        return this.forwardedParser.isSSL();
    }

    @Override
    public HttpServerRequest streamPriorityHandler(Handler<StreamPriority> handler) {
        this.delegate.streamPriorityHandler(handler);
        return this;
    }

    @Override
    public StreamPriority streamPriority() {
        return this.delegate.streamPriority();
    }

    @Override
    public Cookie getCookie(String name) {
        return this.delegate.getCookie(name);
    }

    @Override
    public int cookieCount() {
        return this.delegate.cookieCount();
    }

    @Override
    public Map<String, Cookie> cookieMap() {
        return this.delegate.cookieMap();
    }
}

