/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniDelegatingSubscriber;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;

public class UniOnItemOrFailureMap<I, O>
extends UniOperator<I, O> {
    private final BiFunction<? super I, Throwable, ? extends O> mapper;

    public UniOnItemOrFailureMap(Uni<I> source, BiFunction<? super I, Throwable, ? extends O> mapper) {
        super(ParameterValidation.nonNull(source, "source"));
        this.mapper = ParameterValidation.nonNull(mapper, "mapper");
    }

    @Override
    protected void subscribing(final UniSubscriber<? super O> downstream) {
        AbstractUni.subscribe(this.upstream(), new UniDelegatingSubscriber<I, O>(downstream){
            private final AtomicBoolean done;
            {
                super(subscriber);
                this.done = new AtomicBoolean();
            }

            @Override
            public void onSubscribe(UniSubscription subscription) {
                super.onSubscribe(() -> {
                    this.done.set(true);
                    subscription.cancel();
                });
            }

            @Override
            public void onItem(I item) {
                if (this.done.compareAndSet(false, true)) {
                    Object outcome;
                    try {
                        outcome = UniOnItemOrFailureMap.this.mapper.apply(item, null);
                    }
                    catch (Throwable e) {
                        downstream.onFailure(e);
                        return;
                    }
                    downstream.onItem(outcome);
                }
            }

            @Override
            public void onFailure(Throwable failure) {
                if (this.done.compareAndSet(false, true)) {
                    Object outcome;
                    try {
                        outcome = UniOnItemOrFailureMap.this.mapper.apply(null, failure);
                    }
                    catch (Throwable e) {
                        downstream.onFailure(new CompositeException(failure, e));
                        return;
                    }
                    downstream.onItem(outcome);
                }
            }
        });
    }
}

