/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import java.io.StringReader;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;

public class AbstractJsonObjectResponse {
    private String jsonString;
    private JsonObject json;

    public AbstractJsonObjectResponse() {
    }

    public AbstractJsonObjectResponse(String jsonString) {
        this(AbstractJsonObjectResponse.toJsonObject(jsonString));
        this.jsonString = jsonString;
    }

    public AbstractJsonObjectResponse(JsonObject json) {
        this.json = json;
    }

    public String getString(String name) {
        return this.json.getString(name);
    }

    public Boolean getBoolean(String name) {
        return this.json.getBoolean(name);
    }

    public Long getLong(String name) {
        JsonNumber number = this.json.getJsonNumber(name);
        return number != null ? Long.valueOf(number.longValue()) : null;
    }

    public JsonArray getArray(String name) {
        return this.json.getJsonArray(name);
    }

    public JsonObject getObject(String name) {
        return this.json.getJsonObject(name);
    }

    public JsonObject getJsonObject() {
        return this.json;
    }

    public Object get(String name) {
        return this.json.get(name);
    }

    public boolean contains(String propertyName) {
        return this.json.containsKey(propertyName);
    }

    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.json.keySet());
    }

    public Set<Map.Entry<String, JsonValue>> getAllProperties() {
        return Collections.unmodifiableSet(this.json.entrySet());
    }

    protected String getNonNullJsonString() {
        return this.jsonString == null ? this.json.toString() : this.jsonString;
    }

    private static JsonObject toJsonObject(String userInfoJson) {
        try (JsonReader jsonReader = Json.createReader(new StringReader(userInfoJson));){
            JsonObject jsonObject = jsonReader.readObject();
            return jsonObject;
        }
    }
}

