/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.oidc.AuthorizationCodeTokens;
import io.quarkus.oidc.IdTokenCredential;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.SecurityEvent;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.runtime.AbstractOidcAuthenticationMechanism;
import io.quarkus.oidc.runtime.BlockingTaskRunner;
import io.quarkus.oidc.runtime.CodeAuthenticationStateBean;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.PkceStateBean;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.oidc.runtime.TokenAutoRefreshException;
import io.quarkus.security.AuthenticationCompletionException;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.AuthenticationRedirectException;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.smallrye.jwt.build.Jwt;
import io.smallrye.jwt.util.KeyUtils;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.vertx.core.Handler;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.impl.CookieImpl;
import io.vertx.core.http.impl.ServerCookie;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.mutiny.core.MultiMap;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.jose4j.jwt.consumer.InvalidJwtException;

public class CodeAuthenticationMechanism
extends AbstractOidcAuthenticationMechanism {
    static final String AMP = "&";
    static final String EQ = "=";
    static final String UNDERSCORE = "_";
    static final String COOKIE_DELIM = "|";
    static final Pattern COOKIE_PATTERN = Pattern.compile("\\|");
    static final String SESSION_MAX_AGE_PARAM = "session-max-age";
    static final String STATE_COOKIE_RESTORE_PATH = "restore-path";
    static final Uni<Void> VOID_UNI = Uni.createFrom().voidItem();
    static final Integer MAX_COOKIE_VALUE_LENGTH = 4096;
    static final String NO_OIDC_COOKIES_AVAILABLE = "no_oidc_cookies";
    static final String FORM_URL_ENCODED_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final String INTERNAL_IDTOKEN_HEADER = "internal";
    private static final Logger LOG = Logger.getLogger(CodeAuthenticationMechanism.class);
    private final BlockingTaskRunner<String> createTokenStateRequestContext = new BlockingTaskRunner();
    private final BlockingTaskRunner<AuthorizationCodeTokens> getTokenStateRequestContext = new BlockingTaskRunner();
    private final SecureRandom secureRandom = new SecureRandom();

    public Uni<SecurityIdentity> authenticate(final RoutingContext context, final IdentityProviderManager identityProviderManager, final OidcTenantConfig oidcTenantConfig) {
        final Cookie sessionCookie = context.request().getCookie(CodeAuthenticationMechanism.getSessionCookieName(oidcTenantConfig));
        if (sessionCookie != null) {
            context.put("q_session", sessionCookie.getName());
            Uni<TenantConfigContext> resolvedContext = this.resolver.resolveContext(context);
            return resolvedContext.onItem().transformToUni(new Function<TenantConfigContext, Uni<? extends SecurityIdentity>>(){

                @Override
                public Uni<SecurityIdentity> apply(TenantConfigContext tenantContext) {
                    return CodeAuthenticationMechanism.this.reAuthenticate(sessionCookie, context, identityProviderManager, tenantContext);
                }
            });
        }
        final Cookie stateCookie = context.request().getCookie(CodeAuthenticationMechanism.getStateCookieName(oidcTenantConfig));
        if (stateCookie != null) {
            if (OidcTenantConfig.Authentication.ResponseMode.FORM_POST == oidcTenantConfig.authentication.responseMode.orElse(OidcTenantConfig.Authentication.ResponseMode.QUERY)) {
                String contentType = context.request().getHeader("Content-Type");
                if (context.request().method() == HttpMethod.POST && contentType != null && (contentType.equals(FORM_URL_ENCODED_CONTENT_TYPE) || contentType.startsWith("application/x-www-form-urlencoded;"))) {
                    context.request().setExpectMultipart(true);
                    return Uni.createFrom().emitter(new Consumer<UniEmitter<? super io.vertx.core.MultiMap>>(){

                        @Override
                        public void accept(final UniEmitter<? super io.vertx.core.MultiMap> t) {
                            context.request().endHandler((Handler)new Handler<Void>(){

                                @Override
                                public void handle(Void event) {
                                    t.complete(context.request().formAttributes());
                                }
                            });
                            context.request().resume();
                        }
                    }).onItem().transformToUni(new Function<io.vertx.core.MultiMap, Uni<? extends SecurityIdentity>>(){

                        @Override
                        public Uni<? extends SecurityIdentity> apply(io.vertx.core.MultiMap requestParams) {
                            return CodeAuthenticationMechanism.this.processRedirectFromOidc(context, oidcTenantConfig, identityProviderManager, stateCookie, requestParams);
                        }
                    });
                }
                LOG.debug("HTTP POST and application/x-www-form-urlencoded content type must be used with the form_post response mode");
                return Uni.createFrom().failure(new AuthenticationFailedException());
            }
            return this.processRedirectFromOidc(context, oidcTenantConfig, identityProviderManager, stateCookie, context.queryParams());
        }
        context.put(NO_OIDC_COOKIES_AVAILABLE, Boolean.TRUE);
        return Uni.createFrom().optional(Optional.empty());
    }

    private Uni<SecurityIdentity> processRedirectFromOidc(final RoutingContext context, OidcTenantConfig oidcTenantConfig, final IdentityProviderManager identityProviderManager, Cookie stateCookie, final io.vertx.core.MultiMap requestParams) {
        final String[] parsedStateCookieValue = COOKIE_PATTERN.split(stateCookie.getValue());
        OidcUtils.removeCookie(context, oidcTenantConfig, stateCookie.getName());
        if (!this.isStateValid(requestParams, parsedStateCookieValue[0])) {
            return Uni.createFrom().failure(new AuthenticationCompletionException());
        }
        if (requestParams.contains("code")) {
            Uni<TenantConfigContext> resolvedContext = this.resolver.resolveContext(context);
            return resolvedContext.onItem().transformToUni(new Function<TenantConfigContext, Uni<? extends SecurityIdentity>>(){

                @Override
                public Uni<SecurityIdentity> apply(TenantConfigContext tenantContext) {
                    return CodeAuthenticationMechanism.this.performCodeFlow(identityProviderManager, context, tenantContext, requestParams, parsedStateCookieValue);
                }
            });
        }
        if (requestParams.contains("error")) {
            OidcUtils.removeCookie(context, oidcTenantConfig, stateCookie.getName());
            String error = requestParams.get("error");
            String errorDescription = requestParams.get("error_description");
            LOG.debugf("Authentication has failed, error: %s, description: %s", (Object)error, (Object)errorDescription);
            if (oidcTenantConfig.authentication.errorPath.isPresent()) {
                URI absoluteUri = URI.create(context.request().absoluteURI());
                StringBuilder errorUri = new StringBuilder(this.buildUri(context, this.isForceHttps(oidcTenantConfig), absoluteUri.getAuthority(), oidcTenantConfig.authentication.errorPath.get()));
                errorUri.append('?').append(this.getRequestParametersAsQuery(absoluteUri, requestParams, oidcTenantConfig));
                String finalErrorUri = errorUri.toString();
                LOG.debugf("Error URI: %s", (Object)finalErrorUri);
                return Uni.createFrom().failure(new AuthenticationRedirectException(finalErrorUri));
            }
            return Uni.createFrom().failure(new AuthenticationCompletionException());
        }
        LOG.debug("State cookie is present but neither 'code' nor 'error' query parameter is returned");
        return Uni.createFrom().failure(new AuthenticationCompletionException());
    }

    private String getRequestParametersAsQuery(URI requestUri, io.vertx.core.MultiMap requestParams, OidcTenantConfig oidcConfig) {
        if (OidcTenantConfig.Authentication.ResponseMode.FORM_POST == oidcConfig.authentication.responseMode.orElse(OidcTenantConfig.Authentication.ResponseMode.QUERY)) {
            return OidcCommonUtils.encodeForm(new MultiMap(requestParams)).toString();
        }
        return requestUri.getRawQuery();
    }

    private boolean isStateValid(io.vertx.core.MultiMap requestParams, String cookieState) {
        List<String> values = requestParams.getAll("state");
        if (values.size() != 1) {
            LOG.debug("State parameter can not be empty or multi-valued");
            return false;
        }
        if (!cookieState.equals(values.get(0))) {
            LOG.debug("State cookie value does not match the state query parameter value");
            return false;
        }
        return true;
    }

    private Uni<SecurityIdentity> reAuthenticate(Cookie sessionCookie, final RoutingContext context, final IdentityProviderManager identityProviderManager, final TenantConfigContext configContext) {
        context.put(TenantConfigContext.class.getName(), configContext);
        return this.resolver.getTokenStateManager().getTokens(context, configContext.oidcConfig, sessionCookie.getValue(), this.getTokenStateRequestContext).chain(new Function<AuthorizationCodeTokens, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<? extends SecurityIdentity> apply(final AuthorizationCodeTokens session) {
                context.put("access_token", session.getAccessToken());
                context.put(AuthorizationCodeTokens.class.getName(), session);
                return CodeAuthenticationMechanism.this.authenticate(identityProviderManager, context, new IdTokenCredential(session.getIdToken(), CodeAuthenticationMechanism.this.isInternalIdToken(session.getIdToken(), configContext))).call(new Function<SecurityIdentity, Uni<?>>(){

                    @Override
                    public Uni<Void> apply(SecurityIdentity identity) {
                        if (CodeAuthenticationMechanism.this.isLogout(context, configContext)) {
                            CodeAuthenticationMechanism.this.fireEvent(SecurityEvent.Type.OIDC_LOGOUT_RP_INITIATED, identity);
                            return CodeAuthenticationMechanism.this.buildLogoutRedirectUriUni(context, configContext, session.getIdToken());
                        }
                        return VOID_UNI;
                    }
                }).onFailure().recoverWithUni((Function<Throwable, Uni<SecurityIdentity>>)new Function<Throwable, Uni<? extends SecurityIdentity>>(){

                    @Override
                    public Uni<? extends SecurityIdentity> apply(Throwable t) {
                        if (t instanceof AuthenticationRedirectException) {
                            throw (AuthenticationRedirectException)t;
                        }
                        if (!(t instanceof TokenAutoRefreshException)) {
                            boolean expired;
                            boolean bl = expired = t.getCause() instanceof InvalidJwtException && ((InvalidJwtException)t.getCause()).hasErrorCode(1);
                            if (!expired) {
                                LOG.debugf("Authentication failure: %s", (Object)t.getCause());
                                throw new AuthenticationCompletionException(t.getCause());
                            }
                            if (!configContext.oidcConfig.token.refreshExpired) {
                                LOG.debug("Token has expired, token refresh is not allowed");
                                throw new AuthenticationCompletionException(t.getCause());
                            }
                            LOG.debug("Token has expired, trying to refresh it");
                            return CodeAuthenticationMechanism.this.refreshSecurityIdentity(configContext, session.getRefreshToken(), context, identityProviderManager, false, null);
                        }
                        return CodeAuthenticationMechanism.this.refreshSecurityIdentity(configContext, session.getRefreshToken(), context, identityProviderManager, true, ((TokenAutoRefreshException)t).getSecurityIdentity());
                    }
                });
            }
        });
    }

    private boolean isInternalIdToken(String idToken, TenantConfigContext configContext) {
        JsonObject headers;
        if (!configContext.oidcConfig.authentication.idTokenRequired.orElse(true).booleanValue() && (headers = OidcUtils.decodeJwtHeaders(idToken)) != null) {
            return headers.getBoolean(INTERNAL_IDTOKEN_HEADER, false);
        }
        return false;
    }

    private boolean isJavaScript(RoutingContext context) {
        String value = context.request().getHeader("X-Requested-With");
        return "JavaScript".equals(value) || "XMLHttpRequest".equals(value);
    }

    private boolean shouldAutoRedirect(TenantConfigContext configContext, RoutingContext context) {
        return this.isJavaScript(context) ? configContext.oidcConfig.authentication.javaScriptAutoRedirect : true;
    }

    public Uni<ChallengeData> getChallenge(final RoutingContext context) {
        Uni<TenantConfigContext> tenantContext = this.resolver.resolveContext(context);
        return tenantContext.onItem().transformToUni(new Function<TenantConfigContext, Uni<? extends ChallengeData>>(){

            @Override
            public Uni<ChallengeData> apply(TenantConfigContext tenantContext) {
                return CodeAuthenticationMechanism.this.getChallengeInternal(context, tenantContext);
            }
        });
    }

    public Uni<ChallengeData> getChallengeInternal(final RoutingContext context, final TenantConfigContext configContext) {
        return this.removeSessionCookie(context, configContext.oidcConfig).chain(new Function<Void, Uni<? extends ChallengeData>>(){

            @Override
            public Uni<ChallengeData> apply(Void t) {
                if (context.get(CodeAuthenticationMechanism.NO_OIDC_COOKIES_AVAILABLE) != null && CodeAuthenticationMechanism.this.isRedirectFromProvider(context, configContext)) {
                    LOG.debug("The state cookie is missing after the redirect from OpenId Connect Provider, authentication has failed");
                    return Uni.createFrom().item(new ChallengeData(401, "WWW-Authenticate", "OIDC"));
                }
                if (!CodeAuthenticationMechanism.this.shouldAutoRedirect(configContext, context)) {
                    return Uni.createFrom().item(new ChallengeData(499, "WWW-Authenticate", "OIDC"));
                }
                StringBuilder codeFlowParams = new StringBuilder(168);
                codeFlowParams.append("response_type").append(CodeAuthenticationMechanism.EQ).append("code");
                if (OidcTenantConfig.Authentication.ResponseMode.FORM_POST == configContext.oidcConfig.authentication.responseMode.orElse(OidcTenantConfig.Authentication.ResponseMode.QUERY)) {
                    codeFlowParams.append("response_mode").append(CodeAuthenticationMechanism.EQ).append(configContext.oidcConfig.authentication.responseMode.get().toString().toLowerCase());
                }
                codeFlowParams.append(CodeAuthenticationMechanism.AMP).append("client_id").append(CodeAuthenticationMechanism.EQ).append(OidcCommonUtils.urlEncode((String)configContext.oidcConfig.clientId.get()));
                List oidcConfigScopes = configContext.oidcConfig.getAuthentication().scopes.isPresent() ? configContext.oidcConfig.getAuthentication().scopes.get() : Collections.emptyList();
                ArrayList<String> scopes = new ArrayList<String>(oidcConfigScopes.size() + 1);
                scopes.add("openid");
                scopes.addAll(oidcConfigScopes);
                configContext.oidcConfig.getAuthentication().scopes.ifPresent(scopes::addAll);
                codeFlowParams.append(CodeAuthenticationMechanism.AMP).append("scope").append(CodeAuthenticationMechanism.EQ).append(OidcCommonUtils.urlEncode(String.join((CharSequence)" ", scopes)));
                String redirectPath = CodeAuthenticationMechanism.this.getRedirectPath(configContext, context);
                String redirectUriParam = CodeAuthenticationMechanism.this.buildUri(context, CodeAuthenticationMechanism.this.isForceHttps(configContext.oidcConfig), redirectPath);
                LOG.debugf("Authentication request redirect_uri parameter: %s", (Object)redirectUriParam);
                codeFlowParams.append(CodeAuthenticationMechanism.AMP).append("redirect_uri").append(CodeAuthenticationMechanism.EQ).append(OidcCommonUtils.urlEncode(redirectUriParam));
                PkceStateBean pkceStateBean = CodeAuthenticationMechanism.this.createPkceStateBean(configContext);
                codeFlowParams.append(CodeAuthenticationMechanism.AMP).append("state").append(CodeAuthenticationMechanism.EQ).append(CodeAuthenticationMechanism.this.generateCodeFlowState(context, configContext, redirectPath, pkceStateBean != null ? pkceStateBean.getCodeVerifier() : null));
                if (pkceStateBean != null) {
                    codeFlowParams.append(CodeAuthenticationMechanism.AMP).append("code_challenge").append(CodeAuthenticationMechanism.EQ).append(pkceStateBean.getCodeChallenge());
                    codeFlowParams.append(CodeAuthenticationMechanism.AMP).append("code_challenge_method").append(CodeAuthenticationMechanism.EQ).append("S256");
                }
                CodeAuthenticationMechanism.addExtraParamsToUri(codeFlowParams, configContext.oidcConfig.authentication.getExtraParams());
                String authorizationURL = configContext.provider.getMetadata().getAuthorizationUri() + "?" + codeFlowParams.toString();
                return Uni.createFrom().item(new ChallengeData(HttpResponseStatus.FOUND.code(), HttpHeaders.LOCATION, authorizationURL));
            }
        });
    }

    private boolean isRedirectFromProvider(RoutingContext context, TenantConfigContext configContext) {
        String referer = context.request().getHeader(HttpHeaders.REFERER);
        return referer != null && referer.startsWith(configContext.provider.getMetadata().getAuthorizationUri());
    }

    private PkceStateBean createPkceStateBean(TenantConfigContext configContext) {
        if (configContext.oidcConfig.authentication.pkceRequired.orElse(false).booleanValue()) {
            PkceStateBean bean = new PkceStateBean();
            Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
            byte[] codeVerifierBytes = new byte[32];
            this.secureRandom.nextBytes(codeVerifierBytes);
            String codeVerifier = encoder.encodeToString(codeVerifierBytes);
            bean.setCodeVerifier(codeVerifier);
            try {
                byte[] codeChallengeBytes = OidcUtils.getSha256Digest(codeVerifier.getBytes(StandardCharsets.ISO_8859_1));
                String codeChallenge = encoder.encodeToString(codeChallengeBytes);
                bean.setCodeChallenge(codeChallenge);
            }
            catch (Exception ex) {
                throw new AuthenticationFailedException(ex);
            }
            return bean;
        }
        return null;
    }

    private Uni<SecurityIdentity> performCodeFlow(final IdentityProviderManager identityProviderManager, final RoutingContext context, final TenantConfigContext configContext, final io.vertx.core.MultiMap requestParams, String[] parsedStateCookieValue) {
        String userPath = null;
        String userQuery = null;
        CodeAuthenticationStateBean stateBean = this.getCodeAuthenticationBean(parsedStateCookieValue, configContext);
        if (stateBean != null && stateBean.getRestorePath() != null) {
            String restorePath = stateBean.getRestorePath();
            int userQueryIndex = restorePath.indexOf("?");
            if (userQueryIndex >= 0) {
                userPath = restorePath.substring(0, userQueryIndex);
                if (userQueryIndex + 1 < restorePath.length()) {
                    userQuery = restorePath.substring(userQueryIndex + 1);
                }
            } else {
                userPath = restorePath;
            }
        }
        final String finalUserPath = userPath;
        final String finalUserQuery = userQuery;
        String code = requestParams.get("code");
        Uni<AuthorizationCodeTokens> codeFlowTokensUni = this.getCodeFlowTokensUni(context, configContext, code, stateBean != null ? stateBean.getCodeVerifier() : null);
        return codeFlowTokensUni.onItemOrFailure().transformToUni(new BiFunction<AuthorizationCodeTokens, Throwable, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(final AuthorizationCodeTokens tokens, Throwable tOuter) {
                if (tOuter != null) {
                    LOG.debugf("Exception during the code to token exchange: %s", (Object)tOuter.getMessage());
                    return Uni.createFrom().failure(new AuthenticationCompletionException(tOuter));
                }
                boolean internalIdToken = false;
                if (tokens.getIdToken() == null) {
                    if (configContext.oidcConfig.authentication.isIdTokenRequired().orElse(true).booleanValue()) {
                        return Uni.createFrom().failure(new AuthenticationCompletionException("ID Token is not available"));
                    }
                    tokens.setIdToken(CodeAuthenticationMechanism.this.generateInternalIdToken(configContext.oidcConfig));
                    internalIdToken = true;
                }
                context.put("new_authentication", Boolean.TRUE);
                context.put("access_token", tokens.getAccessToken());
                context.put(AuthorizationCodeTokens.class.getName(), tokens);
                return CodeAuthenticationMechanism.this.authenticate(identityProviderManager, context, new IdTokenCredential(tokens.getIdToken(), internalIdToken)).call(new Function<SecurityIdentity, Uni<?>>(){

                    @Override
                    public Uni<Void> apply(SecurityIdentity identity) {
                        return CodeAuthenticationMechanism.this.processSuccessfulAuthentication(context, configContext, tokens, identity);
                    }
                }).map(new Function<SecurityIdentity, SecurityIdentity>(){

                    @Override
                    public SecurityIdentity apply(SecurityIdentity identity) {
                        boolean removeRedirectParams = configContext.oidcConfig.authentication.isRemoveRedirectParameters();
                        if (removeRedirectParams || finalUserPath != null || finalUserQuery != null) {
                            URI absoluteUri = URI.create(context.request().absoluteURI());
                            StringBuilder finalUriWithoutQuery = new StringBuilder(CodeAuthenticationMechanism.this.buildUri(context, CodeAuthenticationMechanism.this.isForceHttps(configContext.oidcConfig), absoluteUri.getAuthority(), finalUserPath != null ? finalUserPath : absoluteUri.getRawPath()));
                            if (!removeRedirectParams) {
                                finalUriWithoutQuery.append('?').append(CodeAuthenticationMechanism.this.getRequestParametersAsQuery(absoluteUri, requestParams, configContext.oidcConfig));
                            }
                            if (finalUserQuery != null) {
                                finalUriWithoutQuery.append(!removeRedirectParams ? "" : "?");
                                finalUriWithoutQuery.append(finalUserQuery);
                            }
                            String finalRedirectUri = finalUriWithoutQuery.toString();
                            LOG.debugf("Final redirect URI: %s", (Object)finalRedirectUri);
                            throw new AuthenticationRedirectException(finalRedirectUri);
                        }
                        return identity;
                    }
                }).onFailure().transform(new Function<Throwable, Throwable>(){

                    @Override
                    public Throwable apply(Throwable tInner) {
                        if (tInner instanceof AuthenticationRedirectException) {
                            return tInner;
                        }
                        return new AuthenticationCompletionException(tInner);
                    }
                });
            }
        });
    }

    private CodeAuthenticationStateBean getCodeAuthenticationBean(String[] parsedStateCookieValue, TenantConfigContext configContext) {
        if (parsedStateCookieValue.length == 2) {
            CodeAuthenticationStateBean bean = new CodeAuthenticationStateBean();
            if (!configContext.oidcConfig.authentication.pkceRequired.orElse(false).booleanValue()) {
                bean.setRestorePath(parsedStateCookieValue[1]);
                return bean;
            }
            JsonObject json = null;
            try {
                json = OidcUtils.decryptJson(parsedStateCookieValue[1], configContext.getPkceSecretKey());
            }
            catch (Exception ex) {
                LOG.tracef("State cookie value can not be decrypted for the %s tenant", (Object)configContext.oidcConfig.tenantId.get());
                throw new AuthenticationFailedException(ex);
            }
            bean.setRestorePath(json.getString(STATE_COOKIE_RESTORE_PATH));
            bean.setCodeVerifier(json.getString("code_verifier"));
            return bean;
        }
        return null;
    }

    private String generateInternalIdToken(OidcTenantConfig oidcConfig) {
        return Jwt.claims().jws().header(INTERNAL_IDTOKEN_HEADER, true).sign(KeyUtils.createSecretKeyFromSecret(OidcCommonUtils.clientSecret(oidcConfig.credentials)));
    }

    private Uni<Void> processSuccessfulAuthentication(final RoutingContext context, final TenantConfigContext configContext, final AuthorizationCodeTokens tokens, final SecurityIdentity securityIdentity) {
        return this.removeSessionCookie(context, configContext.oidcConfig).chain(new Function<Void, Uni<? extends Void>>(){

            @Override
            public Uni<? extends Void> apply(Void t) {
                JsonObject idToken = OidcUtils.decodeJwtContent(tokens.getIdToken());
                if (!idToken.containsKey("exp") || !idToken.containsKey("iat")) {
                    LOG.debug("ID Token is required to contain 'exp' and 'iat' claims");
                    throw new AuthenticationCompletionException();
                }
                long maxAge = idToken.getLong("exp") - idToken.getLong("iat");
                if (configContext.oidcConfig.token.lifespanGrace.isPresent()) {
                    maxAge += (long)configContext.oidcConfig.token.lifespanGrace.getAsInt();
                }
                if (configContext.oidcConfig.token.refreshExpired) {
                    maxAge += configContext.oidcConfig.authentication.sessionAgeExtension.getSeconds();
                }
                final long sessionMaxAge = maxAge;
                context.put(CodeAuthenticationMechanism.SESSION_MAX_AGE_PARAM, maxAge);
                context.put(TenantConfigContext.class.getName(), configContext);
                return CodeAuthenticationMechanism.this.resolver.getTokenStateManager().createTokenState(context, configContext.oidcConfig, tokens, CodeAuthenticationMechanism.this.createTokenStateRequestContext).map(new Function<String, Void>(){

                    @Override
                    public Void apply(String cookieValue) {
                        String sessionCookie = CodeAuthenticationMechanism.createCookie(context, configContext.oidcConfig, CodeAuthenticationMechanism.getSessionCookieName(configContext.oidcConfig), cookieValue, sessionMaxAge).getValue();
                        if (sessionCookie.length() >= MAX_COOKIE_VALUE_LENGTH) {
                            LOG.warnf("Session cookie length for the tenant %s is equal or greater than %d bytes. Browsers may ignore this cookie which will cause a new challenge for the authenticated users. Recommendations: 1. Set 'quarkus.oidc.token-state-manager.split-tokens=true' to have the ID, access and refresh tokens stored in separate cookies. 2. Set 'quarkus.oidc.token-state-manager.strategy=id-refresh-tokens' if you do not need to use the access token as a source of roles or to request UserInfo or propagate it to the downstream services. 3. Register a custom 'quarkus.oidc.TokenStateManager' CDI bean with the alternative priority set to 1.", (Object)configContext.oidcConfig.tenantId.get(), (Object)MAX_COOKIE_VALUE_LENGTH);
                        }
                        CodeAuthenticationMechanism.this.fireEvent(SecurityEvent.Type.OIDC_LOGIN, securityIdentity);
                        return null;
                    }
                });
            }
        });
    }

    private void fireEvent(SecurityEvent.Type eventType, SecurityIdentity securityIdentity) {
        if (this.resolver.isSecurityEventObserved()) {
            this.resolver.getSecurityEvent().fire(new SecurityEvent(eventType, securityIdentity));
        }
    }

    private String getRedirectPath(TenantConfigContext configContext, RoutingContext context) {
        OidcTenantConfig.Authentication auth = configContext.oidcConfig.getAuthentication();
        return auth.getRedirectPath().isPresent() ? auth.getRedirectPath().get() : context.request().path();
    }

    private String generateCodeFlowState(RoutingContext context, TenantConfigContext configContext, String redirectPath, String pkceCodeVerifier) {
        boolean restorePath;
        String uuid = UUID.randomUUID().toString();
        Object cookieValue = uuid;
        OidcTenantConfig.Authentication auth = configContext.oidcConfig.getAuthentication();
        boolean bl = restorePath = auth.isRestorePathAfterRedirect() || !auth.redirectPath.isPresent();
        if (restorePath || pkceCodeVerifier != null) {
            CodeAuthenticationStateBean extraStateValue = new CodeAuthenticationStateBean();
            if (restorePath) {
                Object requestPath;
                String requestQuery = context.request().query();
                Object object = requestPath = !redirectPath.equals(context.request().path()) || requestQuery != null ? context.request().path() : "";
                if (requestQuery != null) {
                    requestPath = (String)requestPath + "?" + requestQuery;
                }
                if (!((String)requestPath).isEmpty()) {
                    extraStateValue.setRestorePath((String)requestPath);
                }
            }
            extraStateValue.setCodeVerifier(pkceCodeVerifier);
            if (!extraStateValue.isEmpty()) {
                cookieValue = (String)cookieValue + COOKIE_DELIM + this.encodeExtraStateValue(extraStateValue, configContext);
            }
        }
        CodeAuthenticationMechanism.createCookie(context, configContext.oidcConfig, CodeAuthenticationMechanism.getStateCookieName(configContext.oidcConfig), (String)cookieValue, 1800L);
        return uuid;
    }

    private String encodeExtraStateValue(CodeAuthenticationStateBean extraStateValue, TenantConfigContext configContext) {
        if (extraStateValue.getCodeVerifier() != null) {
            JsonObject json = new JsonObject();
            json.put("code_verifier", extraStateValue.getCodeVerifier());
            if (extraStateValue.getRestorePath() != null) {
                json.put(STATE_COOKIE_RESTORE_PATH, extraStateValue.getRestorePath());
            }
            try {
                return OidcUtils.encryptJson(json, configContext.getPkceSecretKey());
            }
            catch (Exception ex) {
                throw new AuthenticationFailedException(ex);
            }
        }
        return extraStateValue.getRestorePath();
    }

    private String generatePostLogoutState(RoutingContext context, TenantConfigContext configContext) {
        OidcUtils.removeCookie(context, configContext.oidcConfig, CodeAuthenticationMechanism.getPostLogoutCookieName(configContext.oidcConfig));
        return CodeAuthenticationMechanism.createCookie(context, configContext.oidcConfig, CodeAuthenticationMechanism.getPostLogoutCookieName(configContext.oidcConfig), UUID.randomUUID().toString(), 1800L).getValue();
    }

    static ServerCookie createCookie(RoutingContext context, OidcTenantConfig oidcConfig, String name, String value, long maxAge) {
        CookieImpl cookie = new CookieImpl(name, value);
        cookie.setHttpOnly(true);
        cookie.setSecure(oidcConfig.authentication.cookieForceSecure || context.request().isSSL());
        cookie.setMaxAge(maxAge);
        LOG.debugf(name + " cookie 'max-age' parameter is set to %d", maxAge);
        OidcTenantConfig.Authentication auth = oidcConfig.getAuthentication();
        OidcUtils.setCookiePath(context, auth, cookie);
        if (auth.cookieDomain.isPresent()) {
            cookie.setDomain(auth.getCookieDomain().get());
        }
        context.response().addCookie(cookie);
        return cookie;
    }

    private String buildUri(RoutingContext context, boolean forceHttps, String path) {
        String authority = URI.create(context.request().absoluteURI()).getAuthority();
        return this.buildUri(context, forceHttps, authority, path);
    }

    private String buildUri(RoutingContext context, boolean forceHttps, String authority, String path) {
        String forwardedPrefixHeader;
        String scheme = forceHttps ? "https" : context.request().scheme();
        String forwardedPrefix = "";
        if (this.resolver.isEnableHttpForwardedPrefix() && (forwardedPrefixHeader = context.request().getHeader("X-Forwarded-Prefix")) != null && !forwardedPrefixHeader.equals("/") && !forwardedPrefixHeader.equals("//") && (forwardedPrefix = forwardedPrefixHeader).endsWith("/")) {
            forwardedPrefix = forwardedPrefix.substring(0, forwardedPrefix.length() - 1);
        }
        return scheme + "://" + authority + forwardedPrefix + path;
    }

    private boolean isLogout(RoutingContext context, TenantConfigContext configContext) {
        Optional<String> logoutPath = configContext.oidcConfig.logout.path;
        if (logoutPath.isPresent()) {
            return context.request().absoluteURI().equals(this.buildUri(context, false, logoutPath.get()));
        }
        return false;
    }

    private Uni<SecurityIdentity> refreshSecurityIdentity(final TenantConfigContext configContext, String refreshToken, final RoutingContext context, final IdentityProviderManager identityProviderManager, final boolean autoRefresh, SecurityIdentity fallback) {
        Uni<AuthorizationCodeTokens> refreshedTokensUni = this.refreshTokensUni(configContext, refreshToken);
        return refreshedTokensUni.onItemOrFailure().transformToUni(new BiFunction<AuthorizationCodeTokens, Throwable, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(final AuthorizationCodeTokens tokens, Throwable t) {
                if (t != null) {
                    LOG.debugf("ID token refresh has failed: %s", (Object)t.getMessage());
                    if (autoRefresh) {
                        LOG.debug("Using the current SecurityIdentity since the ID token is still valid");
                        return Uni.createFrom().item(((TokenAutoRefreshException)t).getSecurityIdentity());
                    }
                    return Uni.createFrom().failure(new AuthenticationFailedException(t));
                }
                context.put("access_token", tokens.getAccessToken());
                context.put(AuthorizationCodeTokens.class.getName(), tokens);
                context.put("refresh_token_grant_response", Boolean.TRUE);
                return CodeAuthenticationMechanism.this.authenticate(identityProviderManager, context, new IdTokenCredential(tokens.getIdToken())).call(new Function<SecurityIdentity, Uni<?>>(){

                    @Override
                    public Uni<Void> apply(SecurityIdentity identity) {
                        return CodeAuthenticationMechanism.this.processSuccessfulAuthentication(context, configContext, tokens, identity);
                    }
                }).map(new Function<SecurityIdentity, SecurityIdentity>(){

                    @Override
                    public SecurityIdentity apply(SecurityIdentity identity) {
                        CodeAuthenticationMechanism.this.fireEvent(autoRefresh ? SecurityEvent.Type.OIDC_SESSION_REFRESHED : SecurityEvent.Type.OIDC_SESSION_EXPIRED_AND_REFRESHED, identity);
                        return identity;
                    }
                }).onFailure().transform(new Function<Throwable, Throwable>(){

                    @Override
                    public Throwable apply(Throwable tInner) {
                        return new AuthenticationFailedException(tInner);
                    }
                });
            }
        });
    }

    private Uni<AuthorizationCodeTokens> refreshTokensUni(TenantConfigContext configContext, String refreshToken) {
        return configContext.provider.refreshTokens(refreshToken);
    }

    private Uni<AuthorizationCodeTokens> getCodeFlowTokensUni(RoutingContext context, TenantConfigContext configContext, String code, String codeVerifier) {
        String redirectPath = this.getRedirectPath(configContext, context);
        String redirectUriParam = this.buildUri(context, this.isForceHttps(configContext.oidcConfig), redirectPath);
        LOG.debugf("Token request redirect_uri parameter: %s", (Object)redirectUriParam);
        return configContext.provider.getCodeFlowTokens(code, redirectUriParam, codeVerifier);
    }

    private String buildLogoutRedirectUri(TenantConfigContext configContext, String idToken, RoutingContext context) {
        String logoutPath = configContext.provider.getMetadata().getEndSessionUri();
        StringBuilder logoutUri = new StringBuilder(logoutPath);
        if (idToken != null || configContext.oidcConfig.logout.postLogoutPath.isPresent()) {
            logoutUri.append("?");
        }
        if (idToken != null) {
            logoutUri.append("id_token_hint").append(EQ).append(idToken);
        }
        if (configContext.oidcConfig.logout.postLogoutPath.isPresent()) {
            logoutUri.append(AMP).append(configContext.oidcConfig.logout.getPostLogoutUriParam()).append(EQ).append(this.buildUri(context, this.isForceHttps(configContext.oidcConfig), configContext.oidcConfig.logout.postLogoutPath.get()));
            logoutUri.append(AMP).append("state").append(EQ).append(this.generatePostLogoutState(context, configContext));
        }
        CodeAuthenticationMechanism.addExtraParamsToUri(logoutUri, configContext.oidcConfig.logout.extraParams);
        return logoutUri.toString();
    }

    private static void addExtraParamsToUri(StringBuilder builder, Map<String, String> extraParams) {
        if (extraParams != null) {
            for (Map.Entry<String, String> entry : extraParams.entrySet()) {
                builder.append(AMP).append(entry.getKey()).append(EQ).append(OidcCommonUtils.urlEncode(entry.getValue()));
            }
        }
    }

    private boolean isForceHttps(OidcTenantConfig oidcConfig) {
        return oidcConfig.authentication.forceRedirectHttpsScheme.orElse(false);
    }

    private Uni<Void> buildLogoutRedirectUriUni(final RoutingContext context, final TenantConfigContext configContext, final String idToken) {
        return this.removeSessionCookie(context, configContext.oidcConfig).map(new Function<Void, Void>(){

            @Override
            public Void apply(Void t) {
                throw new AuthenticationRedirectException(CodeAuthenticationMechanism.this.buildLogoutRedirectUri(configContext, idToken, context));
            }
        });
    }

    private static String getStateCookieName(OidcTenantConfig oidcConfig) {
        return "q_auth" + CodeAuthenticationMechanism.getCookieSuffix(oidcConfig);
    }

    private static String getPostLogoutCookieName(OidcTenantConfig oidcConfig) {
        return "q_post_logout" + CodeAuthenticationMechanism.getCookieSuffix(oidcConfig);
    }

    private static String getSessionCookieName(OidcTenantConfig oidcConfig) {
        return "q_session" + CodeAuthenticationMechanism.getCookieSuffix(oidcConfig);
    }

    private Uni<Void> removeSessionCookie(RoutingContext context, OidcTenantConfig oidcConfig) {
        String cookieName = CodeAuthenticationMechanism.getSessionCookieName(oidcConfig);
        return OidcUtils.removeSessionCookie(context, oidcConfig, cookieName, this.resolver.getTokenStateManager());
    }

    static String getCookieSuffix(OidcTenantConfig oidcConfig) {
        String tenantId = oidcConfig.tenantId.get();
        boolean cookieSuffixConfigured = oidcConfig.authentication.cookieSuffix.isPresent();
        String tenantIdSuffix = cookieSuffixConfigured || !"Default".equals(tenantId) ? UNDERSCORE + tenantId : "";
        return cookieSuffixConfigured ? tenantIdSuffix + UNDERSCORE + oidcConfig.authentication.cookieSuffix.get() : tenantIdSuffix;
    }
}

