/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.runtime.OidcProvider;
import io.smallrye.jwt.util.KeyUtils;
import javax.crypto.SecretKey;

public class TenantConfigContext {
    final OidcProvider provider;
    final OidcTenantConfig oidcConfig;
    private final SecretKey pkceSecretKey;
    private final SecretKey tokenEncSecretKey;
    final boolean ready;

    public TenantConfigContext(OidcProvider client, OidcTenantConfig config) {
        this(client, config, true);
    }

    public TenantConfigContext(OidcProvider client, OidcTenantConfig config, boolean ready) {
        this.provider = client;
        this.oidcConfig = config;
        this.ready = ready;
        this.pkceSecretKey = TenantConfigContext.createPkceSecretKey(config);
        this.tokenEncSecretKey = TenantConfigContext.createTokenEncSecretKey(config);
    }

    private static SecretKey createPkceSecretKey(OidcTenantConfig config) {
        if (config.authentication.pkceRequired.orElse(false).booleanValue()) {
            String pkceSecret = config.authentication.pkceSecret.orElse(OidcCommonUtils.clientSecret(config.credentials));
            if (pkceSecret.length() < 32) {
                throw new RuntimeException("Secret key for encrypting PKCE code verifier must be at least 32 characters long");
            }
            return KeyUtils.createSecretKeyFromSecret(pkceSecret);
        }
        return null;
    }

    private static SecretKey createTokenEncSecretKey(OidcTenantConfig config) {
        if (config.tokenStateManager.encryptionRequired.orElse(false).booleanValue()) {
            String encSecret = config.tokenStateManager.encryptionSecret.orElse(OidcCommonUtils.clientSecret(config.credentials));
            if (encSecret.length() < 32) {
                throw new RuntimeException("Secret key for encrypting tokens must be at least 32 characters long");
            }
            return KeyUtils.createSecretKeyFromSecret(encSecret);
        }
        return null;
    }

    public OidcTenantConfig getOidcTenantConfig() {
        return this.oidcConfig;
    }

    public SecretKey getPkceSecretKey() {
        return this.pkceSecretKey;
    }

    public SecretKey getTokenEncSecretKey() {
        return this.tokenEncSecretKey;
    }
}

