/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.webjar;

import io.quarkus.vertx.http.runtime.devmode.FileSystemStaticHandler;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.StaticHandler;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class WebJarStaticHandler
implements Handler<RoutingContext>,
Closeable {
    private static final ReentrantLock HANDLER_CREATION_LOCK = new ReentrantLock();
    private String finalDestination;
    private String path;
    private List<FileSystemStaticHandler.StaticWebRootConfiguration> webRootConfigurations;
    private Handler<RoutingContext> handler;

    public WebJarStaticHandler() {
    }

    public WebJarStaticHandler(String finalDestination, String path, List<FileSystemStaticHandler.StaticWebRootConfiguration> webRootConfigurations) {
        this.finalDestination = finalDestination;
        this.path = path;
        this.webRootConfigurations = webRootConfigurations;
    }

    public String getFinalDestination() {
        return this.finalDestination;
    }

    public void setFinalDestination(String finalDestination) {
        this.finalDestination = finalDestination;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<FileSystemStaticHandler.StaticWebRootConfiguration> getWebRootConfigurations() {
        return this.webRootConfigurations;
    }

    public void setWebRootConfigurations(List<FileSystemStaticHandler.StaticWebRootConfiguration> webRootConfigurations) {
        this.webRootConfigurations = webRootConfigurations;
    }

    @Override
    public void handle(RoutingContext event) {
        block8: {
            if (event.normalizedPath().length() == this.path.length()) {
                event.response().setStatusCode(302);
                event.response().headers().set(HttpHeaders.LOCATION, (CharSequence)(this.path + "/"));
                event.response().end();
                return;
            }
            if (event.normalizedPath().length() == this.path.length() + 1) {
                event.reroute(this.path + "/index.html");
                return;
            }
            if (this.handler == null) {
                try {
                    HANDLER_CREATION_LOCK.lock();
                    if (this.handler != null) break block8;
                    if (this.finalDestination != null && this.finalDestination.startsWith("META-INF")) {
                        this.handler = StaticHandler.create(this.finalDestination).setDefaultContentEncoding("UTF-8");
                        break block8;
                    }
                    if (this.webRootConfigurations != null) {
                        this.handler = new FileSystemStaticHandler(this.webRootConfigurations);
                        break block8;
                    }
                    throw new RuntimeException("Could not determine which StaticHandler to create.");
                }
                finally {
                    HANDLER_CREATION_LOCK.unlock();
                }
            }
        }
        this.handler.handle(event);
    }

    @Override
    public void close() throws IOException {
        if (this.handler instanceof Closeable) {
            ((Closeable)((Object)this.handler)).close();
        }
    }
}

