/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.qute.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.qute.Engine;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.Variant;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.core.interception.jaxrs.SuspendableContainerResponseContext;

@Provider
public class TemplateResponseFilter
implements ContainerResponseFilter {
    @Override
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Object entity = responseContext.getEntity();
        if (entity instanceof TemplateInstance) {
            MediaType mediaType;
            SuspendableContainerResponseContext ctx = (SuspendableContainerResponseContext)responseContext;
            ctx.suspend();
            TemplateInstance instance = (TemplateInstance)entity;
            Object variantsAttr = instance.getAttribute("variants");
            if (variantsAttr != null) {
                ArrayList<javax.ws.rs.core.Variant> variants = new ArrayList<javax.ws.rs.core.Variant>();
                for (Variant variant : (List)variantsAttr) {
                    variants.add(new javax.ws.rs.core.Variant(MediaType.valueOf(variant.getMediaType()), variant.getLocale(), variant.getEncoding()));
                }
                javax.ws.rs.core.Variant selected = requestContext.getRequest().selectVariant(variants);
                if (selected != null) {
                    List<Locale> acceptableLocales;
                    Locale selectedLocale = selected.getLanguage();
                    if (selectedLocale == null && !(acceptableLocales = requestContext.getAcceptableLanguages()).isEmpty()) {
                        selectedLocale = acceptableLocales.get(0);
                    }
                    instance.setAttribute("selectedVariant", new Variant(selectedLocale, selected.getMediaType().toString(), selected.getEncoding()));
                    mediaType = selected.getMediaType();
                } else {
                    mediaType = responseContext.getMediaType();
                }
            } else {
                mediaType = responseContext.getMediaType();
            }
            CompletionStage<String> cs = instance.renderAsync();
            if (!Arc.container().instance(Engine.class, new Annotation[0]).get().useAsyncTimeout()) {
                long timeout = instance.getTimeout();
                cs = cs.toCompletableFuture().orTimeout(timeout, TimeUnit.MILLISECONDS);
            }
            try {
                cs.whenComplete((r, t) -> {
                    if (t == null) {
                        if (mediaType != null) {
                            ctx.setEntity(r, null, mediaType);
                        } else {
                            ctx.setEntity(r);
                        }
                        ctx.resume();
                    } else {
                        ctx.resume((Throwable)t);
                    }
                });
            }
            catch (Throwable t2) {
                ctx.resume(t2);
            }
        }
    }
}

