/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.ui;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.common.ResourceArg;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.keycloak.representations.AccessTokenResponse;
import org.kie.kogito.test.quarkus.QuarkusTestProperty;
import org.kie.kogito.testcontainers.quarkus.KeycloakQuarkusTestResource;

@QuarkusTest
@QuarkusTestResource(value=KeycloakQuarkusTestResource.class, initArgs={@ResourceArg(name="kogito.test.tenants", value="web-app-tenant")})
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
class KeycloakTrustyUIServiceIT {
    private static final String VALID_USER = "jdoe";
    private static final String TRUSTY_UI_ENDPOINT = "/";
    @QuarkusTestProperty(name="quarkus.oidc.auth-server-url")
    String keycloakURL;

    KeycloakTrustyUIServiceIT() {
    }

    @Test
    void shouldReturnUnauthorized() {
        ((ValidatableResponse)((Response)RestAssured.given().get(TRUSTY_UI_ENDPOINT, new Object[0])).then()).statusCode(401);
    }

    @Test
    void shouldReturnOkWhenValidUser() {
        ((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAccessToken(VALID_USER)).get(TRUSTY_UI_ENDPOINT, new Object[0])).then()).statusCode(200);
    }

    private String getAccessToken(String userName) {
        return ((AccessTokenResponse)((Response)RestAssured.given().param("grant_type", new Object[]{"password"}).param("username", new Object[]{userName}).param("password", new Object[]{userName}).param("client_id", new Object[]{"kogito-app"}).param("client_secret", new Object[]{"secret"}).when().post(this.keycloakURL + "/protocol/openid-connect/token", new Object[0])).as(AccessTokenResponse.class)).getToken();
    }
}

