/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.function.Consumer;
import java.util.function.Function;

public class ClassPathUtils {
    private static final String FILE = "file";
    private static final String JAR = "jar";

    public static void consumeAsStreams(String resource, Consumer<InputStream> consumer) throws IOException {
        ClassPathUtils.consumeAsStreams(Thread.currentThread().getContextClassLoader(), resource, consumer);
    }

    public static void consumeAsStreams(ClassLoader cl, String resource, Consumer<InputStream> consumer) throws IOException {
        Enumeration<URL> resources = cl.getResources(resource);
        while (resources.hasMoreElements()) {
            ClassPathUtils.consumeStream(resources.nextElement(), consumer);
        }
    }

    public static void consumeAsPaths(String resource, Consumer<Path> consumer) throws IOException {
        ClassPathUtils.consumeAsPaths(Thread.currentThread().getContextClassLoader(), resource, consumer);
    }

    public static void consumeAsPaths(ClassLoader cl, String resource, Consumer<Path> consumer) throws IOException {
        Enumeration<URL> resources = cl.getResources(resource);
        while (resources.hasMoreElements()) {
            ClassPathUtils.consumeAsPath(resources.nextElement(), consumer);
        }
    }

    public static void consumeAsPath(URL url, Consumer<Path> consumer) {
        ClassPathUtils.processAsPath(url, p -> {
            consumer.accept((Path)p);
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <R> R processAsPath(URL url, Function<Path, R> function) {
        Path jar;
        if (!JAR.equals(url.getProtocol())) {
            if (!FILE.equals(url.getProtocol())) throw new IllegalArgumentException("Unexpected protocol " + url.getProtocol() + " for URL " + url);
            return function.apply(ClassPathUtils.toLocalPath(url));
        }
        String file = url.getFile();
        int exclam = file.lastIndexOf(33);
        try {
            jar = ClassPathUtils.toLocalPath(exclam >= 0 ? new URL(file.substring(0, exclam)) : url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to create a URL for '" + file.substring(0, exclam) + "'", e);
        }
        try (FileSystem jarFs = FileSystems.newFileSystem(jar, (ClassLoader)null);){
            Path localPath = jarFs.getPath("/", new String[0]);
            if (exclam >= 0) {
                localPath = localPath.resolve(file.substring(exclam + 1));
            }
            R r = function.apply(localPath);
            return r;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read " + jar, e);
        }
    }

    public static void consumeStream(URL url, Consumer<InputStream> consumer) throws IOException {
        ClassPathUtils.readStream(url, is -> {
            consumer.accept((InputStream)is);
            return null;
        });
    }

    /*
     * Exception decompiling
     */
    public static <R> R readStream(URL url, Function<InputStream, R> function) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static URI toURI(URL url) throws IOException {
        URI uri;
        try {
            uri = new URI(url.toString());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        return uri;
    }

    public static Path toLocalPath(URL url) {
        try {
            return Paths.get(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to translate " + url + " to local path", e);
        }
    }
}

