/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.vertx;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class AsyncResultUni<T>
extends AbstractUni<T>
implements Uni<T> {
    private final Consumer<Handler<AsyncResult<T>>> subscriptionConsumer;

    public static <T> Uni<T> toUni(Consumer<Handler<AsyncResult<T>>> subscriptionConsumer) {
        return new AsyncResultUni<T>(subscriptionConsumer);
    }

    public AsyncResultUni(Consumer<Handler<AsyncResult<T>>> subscriptionConsumer) {
        this.subscriptionConsumer = subscriptionConsumer;
    }

    @Override
    protected void subscribing(UniSubscriber<? super T> downstream) {
        block3: {
            AtomicBoolean terminated = new AtomicBoolean();
            downstream.onSubscribe(() -> terminated.set(true));
            if (!terminated.get()) {
                try {
                    this.subscriptionConsumer.accept(ar -> {
                        if (!terminated.getAndSet(true)) {
                            if (ar.succeeded()) {
                                Object val = ar.result();
                                downstream.onItem(val);
                            } else if (ar.failed()) {
                                downstream.onFailure(ar.cause());
                            }
                        }
                    });
                }
                catch (Exception e) {
                    if (terminated.getAndSet(true)) break block3;
                    downstream.onFailure(e);
                }
            }
        }
    }
}

