/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.UniOnCancellation;
import io.smallrye.mutiny.operators.UniOnCancellationCall;
import java.util.function.Supplier;

public class UniOnCancel<T> {
    private final Uni<T> upstream;

    public UniOnCancel(Uni<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Uni<T> invoke(Runnable action) {
        return Infrastructure.onUniCreation(new UniOnCancellation<T>(this.upstream, ParameterValidation.nonNull(action, "action")));
    }

    @Deprecated
    public Uni<T> invokeUni(Supplier<Uni<?>> supplier) {
        return this.call(supplier);
    }

    public Uni<T> call(Supplier<Uni<?>> supplier) {
        return Infrastructure.onUniCreation(new UniOnCancellationCall<T>(this.upstream, ParameterValidation.nonNull(supplier, "supplier")));
    }
}

