/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;

public final class ResourceUtils {
    public static final String HTTP_BASED_SCHEME = "http";
    public static final String CLASSPATH_SCHEME = "classpath:";
    public static final String FILE_SCHEME = "file:";

    private ResourceUtils() {
    }

    public static String readResource(String resourceLocation) throws IOException {
        return ResourceUtils.readResource(resourceLocation, null);
    }

    public static String readResource(String resourceLocation, UrlStreamResolver urlResolver) throws IOException {
        InputStream is = ResourceUtils.getResourceStream(resourceLocation, urlResolver);
        if (is == null) {
            return null;
        }
        StringWriter contents = new StringWriter();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                contents.write(line);
            }
        }
        return contents.toString();
    }

    public static InputStream getResourceStream(String resourceLocation) throws IOException {
        return ResourceUtils.getResourceStream(resourceLocation, null);
    }

    public static InputStream getResourceStream(String resourceLocation, UrlStreamResolver urlResolver) throws IOException {
        InputStream is = null;
        if (resourceLocation.startsWith(HTTP_BASED_SCHEME)) {
            is = (urlResolver == null ? ResourceUtils.getUrlResolver() : urlResolver).resolve(resourceLocation);
        } else if (resourceLocation.startsWith(FILE_SCHEME)) {
            is = ResourceUtils.getAsFileSystemResource(resourceLocation.substring(FILE_SCHEME.length()));
        } else if (resourceLocation.startsWith(CLASSPATH_SCHEME)) {
            is = ResourceUtils.getAsClasspathResource(resourceLocation.substring(CLASSPATH_SCHEME.length()));
        } else {
            is = ResourceUtils.getAsFileSystemResource(resourceLocation);
            if (is == null) {
                is = ResourceUtils.getAsClasspathResource(resourceLocation);
            }
            if (is == null) {
                is = ResourceUtils.getUrlResolver().resolve(resourceLocation);
            }
        }
        return is;
    }

    public static UrlStreamResolver getUrlResolver() {
        return new UrlStreamResolver();
    }

    public static InputStream getAsFileSystemResource(String publicKeyLocation) throws IOException {
        try {
            return new FileInputStream(publicKeyLocation);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static InputStream getAsClasspathResource(String location) {
        InputStream is = ResourceUtils.class.getResourceAsStream(location);
        if (is == null) {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(location);
        }
        return is;
    }

    public static class UrlStreamResolver {
        public InputStream resolve(String keyLocation) throws IOException {
            return new URL(keyLocation).openStream();
        }
    }
}

