/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.launcher.commands;

import io.vertx.core.AsyncResult;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.VertxOptions;
import io.vertx.core.cli.annotations.DefaultValue;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Option;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.core.eventbus.AddressHelper;
import io.vertx.core.eventbus.EventBusOptions;
import io.vertx.core.impl.VertxBuilder;
import io.vertx.core.impl.launcher.VertxLifecycleHooks;
import io.vertx.core.impl.launcher.commands.ClasspathHandler;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.launcher.ExecutionContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Properties;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

@Summary(value="Creates a bare instance of vert.x.")
@Description(value="This command launches a vert.x instance but do not deploy any verticles. It will receive a verticle if another node of the cluster dies.")
@Name(value="bare")
public class BareCommand
extends ClasspathHandler {
    public static final String VERTX_OPTIONS_PROP_PREFIX = "vertx.options.";
    public static final String VERTX_EVENTBUS_PROP_PREFIX = "vertx.eventBus.options.";
    public static final String DEPLOYMENT_OPTIONS_PROP_PREFIX = "vertx.deployment.options.";
    public static final String METRICS_OPTIONS_PROP_PREFIX = "vertx.metrics.options.";
    protected Vertx vertx;
    protected int clusterPort;
    protected String clusterHost;
    protected int clusterPublicPort;
    protected String clusterPublicHost;
    protected int quorum;
    protected String haGroup;
    protected String vertxOptions;
    protected VertxOptions options;
    protected Runnable finalAction;
    private static final ThreadLocal<Logger> configureFromSystemProperties = new ThreadLocal();

    @Option(longName="quorum", argName="q")
    @Description(value="Used in conjunction with -ha this specifies the minimum number of nodes in the cluster for any HA deploymentIDs to be active. Defaults to 1.")
    @DefaultValue(value="-1")
    public void setQuorum(int quorum) {
        this.quorum = quorum;
    }

    @Option(longName="hagroup", argName="group")
    @Description(value="used in conjunction with -ha this specifies the HA group this node will join. There can be multiple HA groups in a cluster. Nodes will only failover to other nodes in the same group. Defaults to '__DEFAULT__'.")
    @DefaultValue(value="__DEFAULT__")
    public void setHAGroup(String group) {
        this.haGroup = group;
    }

    @Option(longName="cluster-port", argName="port")
    @Description(value="Port to use for cluster communication. Default is 0 which means choose a spare random port.")
    @DefaultValue(value="0")
    public void setClusterPort(int port) {
        this.clusterPort = port;
    }

    @Option(longName="cluster-host", argName="host")
    @Description(value="host to bind to for cluster communication. If this is not specified vert.x will attempt to choose one from the available interfaces.")
    public void setClusterHost(String host) {
        this.clusterHost = host;
    }

    @Option(longName="cluster-public-port", argName="public-port")
    @Description(value="Public port to use for cluster communication. Default is -1 which means same as cluster port.")
    @DefaultValue(value="-1")
    public void setClusterPublicPort(int port) {
        this.clusterPublicPort = port;
    }

    @Option(longName="cluster-public-host", argName="public-host")
    @Description(value="Public host to bind to for cluster communication. If not specified, Vert.x will use the same as cluster host.")
    public void setClusterPublicHost(String host) {
        this.clusterPublicHost = host;
    }

    @Option(longName="options", argName="options")
    @Description(value="Specifies the Vert.x options. It should reference either a JSON file which represents the options OR be a JSON string.")
    public void setVertxOptions(String vertxOptions) {
        this.vertxOptions = vertxOptions != null ? vertxOptions.trim().replaceAll("^\"|\"$", "").replaceAll("^'|'$", "") : null;
    }

    public boolean isClustered() {
        return true;
    }

    public boolean getHA() {
        return true;
    }

    @Override
    public void run() {
        this.run(null);
    }

    public void run(Runnable action) {
        this.finalAction = action;
        this.vertx = this.startVertx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vertx startVertx() {
        Vertx instance;
        VertxBuilder builder;
        EventBusOptions eventBusOptions;
        JsonObject optionsJson = this.getJsonFromFileOrString(this.vertxOptions, "options");
        if (optionsJson == null) {
            eventBusOptions = this.getEventBusOptions();
            builder = new VertxBuilder();
        } else {
            eventBusOptions = this.getEventBusOptions(optionsJson.getJsonObject("eventBusOptions"));
            builder = new VertxBuilder(optionsJson);
        }
        this.options = builder.options();
        this.options.setEventBusOptions(eventBusOptions);
        this.beforeStartingVertx(this.options);
        builder.init();
        configureFromSystemProperties.set(this.log);
        try {
            BareCommand.configureFromSystemProperties(this.options, VERTX_OPTIONS_PROP_PREFIX);
            if (this.options.getMetricsOptions() != null) {
                BareCommand.configureFromSystemProperties(this.options.getMetricsOptions(), METRICS_OPTIONS_PROP_PREFIX);
            }
        }
        finally {
            configureFromSystemProperties.set(null);
        }
        if (this.isClustered()) {
            this.log.info("Starting clustering...");
            eventBusOptions = this.options.getEventBusOptions();
            if (!Objects.equals(eventBusOptions.getHost(), EventBusOptions.DEFAULT_CLUSTER_HOST)) {
                this.clusterHost = eventBusOptions.getHost();
            }
            if (eventBusOptions.getPort() != 0) {
                this.clusterPort = eventBusOptions.getPort();
            }
            if (!Objects.equals(eventBusOptions.getClusterPublicHost(), EventBusOptions.DEFAULT_CLUSTER_PUBLIC_HOST)) {
                this.clusterPublicHost = eventBusOptions.getClusterPublicHost();
            }
            if (eventBusOptions.getClusterPublicPort() != -1) {
                this.clusterPublicPort = eventBusOptions.getClusterPublicPort();
            }
            eventBusOptions.setHost(this.clusterHost).setPort(this.clusterPort).setClusterPublicHost(this.clusterPublicHost);
            if (this.clusterPublicPort != -1) {
                eventBusOptions.setClusterPublicPort(this.clusterPublicPort);
            }
            if (this.getHA()) {
                this.options.setHAEnabled(true);
                if (this.haGroup != null) {
                    this.options.setHAGroup(this.haGroup);
                }
                if (this.quorum != -1) {
                    this.options.setQuorumSize(this.quorum);
                }
            }
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference result = new AtomicReference();
            this.create(builder, ar -> {
                result.set(ar);
                latch.countDown();
            });
            try {
                if (!latch.await(2L, TimeUnit.MINUTES)) {
                    this.log.error("Timed out in starting clustered Vert.x");
                    return null;
                }
            }
            catch (InterruptedException e) {
                this.log.error("Thread interrupted in startup");
                Thread.currentThread().interrupt();
                return null;
            }
            if (((AsyncResult)result.get()).failed()) {
                this.log.error("Failed to form cluster", ((AsyncResult)result.get()).cause());
                return null;
            }
            instance = (Vertx)((AsyncResult)result.get()).result();
        } else {
            instance = this.create(builder);
        }
        BareCommand.addShutdownHook(instance, this.log, this.finalAction);
        this.afterStartingVertx(instance);
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JsonObject getJsonFromFileOrString(String jsonFileOrString, String argName) {
        if (jsonFileOrString == null) {
            return null;
        }
        try (Scanner scanner = new Scanner(new File(jsonFileOrString), "UTF-8").useDelimiter("\\A");){
            String sconf = scanner.next();
            try {
                JsonObject conf = new JsonObject(sconf);
                return conf;
            }
            catch (DecodeException e) {
                this.log.error("Configuration file " + sconf + " does not contain a valid JSON object");
                JsonObject jsonObject = null;
                if (scanner == null) return jsonObject;
                if (throwable != null) {
                    try {
                        scanner.close();
                        return jsonObject;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return jsonObject;
                    }
                }
                scanner.close();
                return jsonObject;
            }
        }
        catch (FileNotFoundException e) {
            try {
                return new JsonObject(jsonFileOrString);
            }
            catch (DecodeException e2) {
                this.log.error("The -" + argName + " argument does not point to an existing file or is not a valid JSON object", e2);
                return null;
            }
        }
    }

    protected void afterStartingVertx(Vertx instance) {
        Object main = this.executionContext.main();
        if (main instanceof VertxLifecycleHooks) {
            ((VertxLifecycleHooks)main).afterStartingVertx(instance);
        }
    }

    protected void beforeStartingVertx(VertxOptions options) {
        Object main = this.executionContext.main();
        if (main instanceof VertxLifecycleHooks) {
            ((VertxLifecycleHooks)main).beforeStartingVertx(options);
        }
    }

    protected EventBusOptions getEventBusOptions() {
        return this.getEventBusOptions(null);
    }

    protected EventBusOptions getEventBusOptions(JsonObject jsonObject) {
        EventBusOptions eventBusOptions = jsonObject == null ? new EventBusOptions() : new EventBusOptions(jsonObject);
        configureFromSystemProperties.set(this.log);
        try {
            BareCommand.configureFromSystemProperties(eventBusOptions, VERTX_EVENTBUS_PROP_PREFIX);
        }
        finally {
            configureFromSystemProperties.set(null);
        }
        return eventBusOptions;
    }

    public static void configureFromSystemProperties(Object options, String prefix) {
        Logger log = configureFromSystemProperties.get();
        if (log == null) {
            return;
        }
        Properties props = System.getProperties();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            Object arg;
            Method setter;
            block12: {
                String propName = (String)e.nextElement();
                String propVal = props.getProperty(propName);
                if (!propName.startsWith(prefix)) continue;
                String fieldName = propName.substring(prefix.length());
                setter = BareCommand.getSetter(fieldName, options.getClass());
                if (setter == null) {
                    log.warn("No such property to configure on options: " + options.getClass().getName() + "." + fieldName);
                    continue;
                }
                Class<?> argType = setter.getParameterTypes()[0];
                try {
                    if (argType.equals(String.class)) {
                        arg = propVal;
                        break block12;
                    }
                    if (argType.equals(Integer.TYPE)) {
                        arg = Integer.valueOf(propVal);
                        break block12;
                    }
                    if (argType.equals(Long.TYPE)) {
                        arg = Long.valueOf(propVal);
                        break block12;
                    }
                    if (argType.equals(Boolean.TYPE)) {
                        arg = Boolean.valueOf(propVal);
                        break block12;
                    }
                    if (argType.isEnum()) {
                        arg = Enum.valueOf(argType, propVal);
                        break block12;
                    }
                    log.warn("Invalid type for setter: " + argType);
                }
                catch (IllegalArgumentException e2) {
                    log.warn("Invalid argtype:" + argType + " on options: " + options.getClass().getName() + "." + fieldName);
                }
                continue;
            }
            try {
                setter.invoke(options, arg);
            }
            catch (Exception ex) {
                throw new VertxException("Failed to invoke setter: " + setter, ex);
            }
        }
    }

    private static Method getSetter(String fieldName, Class<?> clazz) {
        Method[] meths;
        for (Method meth : meths = clazz.getDeclaredMethods()) {
            if (!("set" + fieldName).equalsIgnoreCase(meth.getName())) continue;
            return meth;
        }
        for (Method meth : meths = clazz.getMethods()) {
            if (!("set" + fieldName).equalsIgnoreCase(meth.getName())) continue;
            return meth;
        }
        return null;
    }

    protected static void addShutdownHook(Vertx vertx, Logger log, Runnable action) {
        Runtime.getRuntime().addShutdownHook(new Thread(BareCommand.getTerminationRunnable(vertx, log, action)));
    }

    public static Runnable getTerminationRunnable(Vertx vertx, Logger log, Runnable action) {
        return () -> {
            CountDownLatch latch = new CountDownLatch(1);
            if (vertx != null) {
                vertx.close(ar -> {
                    if (!ar.succeeded()) {
                        log.error("Failure in stopping Vert.x", ar.cause());
                    }
                    latch.countDown();
                });
                try {
                    if (!latch.await(2L, TimeUnit.MINUTES)) {
                        log.error("Timed out waiting to undeploy all");
                    }
                    if (action != null) {
                        action.run();
                    }
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }

    @Deprecated
    protected String getDefaultAddress() {
        return AddressHelper.defaultAddress();
    }

    public void setExecutionContext(ExecutionContext context) {
        this.executionContext = context;
    }

    public synchronized Vertx vertx() {
        return this.vertx;
    }
}

