/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.consumer;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.core.common.EventFactHandle;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.definition.type.Role;
import org.kie.api.definition.type.Timestamp;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.hacep.EnvConfig;
import org.kie.hacep.consumer.ObjectFilterHelper;
import org.kie.hacep.core.KieSessionContext;
import org.kie.hacep.core.infra.SessionSnapshooter;
import org.kie.hacep.core.infra.utils.ConsumerUtils;
import org.kie.remote.DroolsExecutor;
import org.kie.remote.RemoteFactHandle;
import org.kie.remote.command.DeleteCommand;
import org.kie.remote.command.EventInsertCommand;
import org.kie.remote.command.FactCountCommand;
import org.kie.remote.command.FireAllRulesCommand;
import org.kie.remote.command.FireUntilHaltCommand;
import org.kie.remote.command.GetKJarGAVCommand;
import org.kie.remote.command.GetObjectCommand;
import org.kie.remote.command.HaltCommand;
import org.kie.remote.command.InsertCommand;
import org.kie.remote.command.ListObjectsCommand;
import org.kie.remote.command.ListObjectsCommandClassType;
import org.kie.remote.command.ListObjectsCommandNamedQuery;
import org.kie.remote.command.SnapshotOnDemandCommand;
import org.kie.remote.command.UpdateCommand;
import org.kie.remote.command.UpdateKJarCommand;
import org.kie.remote.command.VisitorCommand;
import org.kie.remote.command.WorkingMemoryActionCommand;
import org.kie.remote.impl.producer.Producer;
import org.kie.remote.message.ControlMessage;
import org.kie.remote.message.FactCountMessage;
import org.kie.remote.message.FireAllRuleMessage;
import org.kie.remote.message.GetKJarGAVMessage;
import org.kie.remote.message.GetObjectMessage;
import org.kie.remote.message.ListKieSessionObjectMessage;
import org.kie.remote.message.ResultMessage;
import org.kie.remote.message.UpdateKjarMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandHandler
implements VisitorCommand {
    private static final Logger logger = LoggerFactory.getLogger(CommandHandler.class);
    private KieSessionContext kieSessionContext;
    private EnvConfig envConfig;
    private Producer producer;
    private SessionSnapshooter sessionSnapshooter;
    private volatile boolean firingUntilHalt;

    public CommandHandler(KieSessionContext kieSessionContext, EnvConfig envConfig, Producer producer, SessionSnapshooter sessionSnapshooter) {
        this.kieSessionContext = kieSessionContext;
        this.envConfig = envConfig;
        this.producer = producer;
        this.sessionSnapshooter = sessionSnapshooter;
    }

    public void visit(FireAllRulesCommand command) {
        int fires = this.kieSessionContext.getKieSession().fireAllRules();
        FireAllRuleMessage msg = new FireAllRuleMessage(command.getId(), (long)fires);
        if (DroolsExecutor.getInstance().isLeader()) {
            this.producer.produceSync(this.envConfig.getKieSessionInfosTopicName(), command.getId(), (ResultMessage)msg);
        }
    }

    public void visit(FireUntilHaltCommand command) {
        this.firingUntilHalt = true;
    }

    public void visit(HaltCommand command) {
        this.firingUntilHalt = false;
    }

    public void visit(InsertCommand command) {
        RemoteFactHandle remoteFH = command.getFactHandle();
        FactHandle fh = this.internalInsert((WorkingMemoryActionCommand)command, remoteFH.getObject());
        this.kieSessionContext.getFhManager().registerHandle(remoteFH, fh);
    }

    public void visit(EventInsertCommand command) {
        this.internalInsert((WorkingMemoryActionCommand)command, command.getObject());
    }

    private FactHandle internalInsert(WorkingMemoryActionCommand command, Object obj) {
        FactHandle fh;
        FactHandle factHandle = fh = CommandHandler.isEvent(obj) ? this.insertEvent(command, obj) : this.insertFact(command, obj);
        if (this.firingUntilHalt) {
            this.kieSessionContext.getKieSession().fireAllRules();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("firingUntilHalt:{}", (Object)this.firingUntilHalt);
        }
        return fh;
    }

    private FactHandle insertEvent(WorkingMemoryActionCommand command, Object obj) {
        FactHandle fh;
        if (CommandHandler.hasTimestamp(obj)) {
            fh = this.insertFact(command, obj);
            this.kieSessionContext.setClockAt(((EventFactHandle)fh).getStartTimestamp());
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Event class " + obj.getClass().getName() + " doesn't have a timestamp property. Consider adding one.");
            }
            this.kieSessionContext.setClockAt(command.getTimestamp());
            fh = this.insertFact(command, obj);
        }
        return fh;
    }

    private FactHandle insertFact(WorkingMemoryActionCommand command, Object obj) {
        return this.kieSessionContext.getKieSession().getEntryPoint(command.getEntryPoint()).insert(obj);
    }

    public void visit(DeleteCommand command) {
        FactHandle factHandle = this.kieSessionContext.getFhManager().mapRemoteFactHandle(command.getFactHandle());
        this.kieSessionContext.getKieSession().getEntryPoint(command.getEntryPoint()).delete(factHandle);
        if (this.firingUntilHalt) {
            this.kieSessionContext.getKieSession().fireAllRules();
        }
    }

    public void visit(UpdateCommand command) {
        FactHandle factHandle = this.kieSessionContext.getFhManager().mapRemoteFactHandle(command.getFactHandle());
        this.kieSessionContext.getKieSession().getEntryPoint(command.getEntryPoint()).update(factHandle, command.getObject());
        if (this.firingUntilHalt) {
            this.kieSessionContext.getKieSession().fireAllRules();
        }
    }

    public void visit(ListObjectsCommand command) {
        List serializableItems = this.getObjectList(command);
        ListKieSessionObjectMessage msg = new ListKieSessionObjectMessage(command.getId(), (Collection)serializableItems);
        this.producer.produceSync(this.envConfig.getKieSessionInfosTopicName(), command.getId(), (ResultMessage)msg);
    }

    private List getObjectList(ListObjectsCommand command) {
        Collection objects = this.kieSessionContext.getKieSession().getEntryPoint(command.getEntryPoint()).getObjects();
        return this.getListFromSerializableCollection(objects);
    }

    public void visit(ListObjectsCommandClassType command) {
        List serializableItems = this.getSerializableItemsByClassType(command);
        ListKieSessionObjectMessage msg = new ListKieSessionObjectMessage(command.getId(), (Collection)serializableItems);
        this.producer.produceSync(this.envConfig.getKieSessionInfosTopicName(), command.getId(), (ResultMessage)msg);
    }

    public void visit(GetObjectCommand command) {
        FactHandle factHandle = this.kieSessionContext.getFhManager().mapRemoteFactHandle(command.getRemoteFactHandle());
        Object object = this.kieSessionContext.getKieSession().getObject(factHandle);
        GetObjectMessage msg = new GetObjectMessage(command.getId(), object);
        this.producer.produceSync(this.envConfig.getKieSessionInfosTopicName(), command.getId(), (ResultMessage)msg);
    }

    private List getSerializableItemsByClassType(ListObjectsCommandClassType command) {
        Collection<? extends Object> objects = ObjectFilterHelper.getObjectsFilterByClassType(command.getClazzType(), this.kieSessionContext.getKieSession());
        return this.getListFromSerializableCollection(objects);
    }

    private List getListFromSerializableCollection(Collection<?> objects) {
        ArrayList serializableItems = new ArrayList(objects.size());
        for (Object o : objects) {
            serializableItems.add(o);
        }
        return serializableItems;
    }

    public void visit(ListObjectsCommandNamedQuery command) {
        List serializableItems = this.getSerializableItemsByNamedQuery(command);
        ListKieSessionObjectMessage msg = new ListKieSessionObjectMessage(command.getId(), (Collection)serializableItems);
        this.producer.produceSync(this.envConfig.getKieSessionInfosTopicName(), command.getId(), (ResultMessage)msg);
    }

    private List getSerializableItemsByNamedQuery(ListObjectsCommandNamedQuery command) {
        Collection<? extends Object> objects = ObjectFilterHelper.getObjectsFilterByNamedQuery(command.getNamedQuery(), command.getObjectName(), command.getParams(), this.kieSessionContext.getKieSession());
        return this.getListFromSerializableCollection(objects);
    }

    public void visit(FactCountCommand command) {
        FactCountMessage msg = new FactCountMessage(command.getId(), this.kieSessionContext.getKieSession().getFactCount());
        this.producer.produceSync(this.envConfig.getKieSessionInfosTopicName(), command.getId(), (ResultMessage)msg);
    }

    public void visit(SnapshotOnDemandCommand command) {
        LocalDateTime lastSnapshotTime = this.sessionSnapshooter.getLastSnapshotTime();
        if (lastSnapshotTime == null) {
            this.sessionSnapshooter.serialize(this.kieSessionContext, command.getId(), 0L);
        } else if (LocalDateTime.now().minusSeconds(this.envConfig.getMaxSnapshotAge()).isAfter(lastSnapshotTime)) {
            ControlMessage lastControlMessage = ConsumerUtils.getLastEvent(this.envConfig.getControlTopicName(), this.envConfig.getPollTimeout());
            if (lastControlMessage != null) {
                this.sessionSnapshooter.serialize(this.kieSessionContext, lastControlMessage.getId(), lastControlMessage.getOffset());
            } else {
                this.sessionSnapshooter.serialize(this.kieSessionContext, command.getId(), 0L);
            }
        }
    }

    public void visit(UpdateKJarCommand command) {
        KieServices ks = KieServices.get();
        UpdateKjarMessage msg = new UpdateKjarMessage(command.getId(), Boolean.FALSE.booleanValue());
        if (ks != null) {
            ReleaseId releaseId = ks.newReleaseId(command.getGroupID(), command.getArtifactID(), command.getVersion());
            if (this.envConfig.isUpdatableKJar()) {
                try {
                    this.kieSessionContext.getKieContainer().updateToVersion(releaseId);
                    msg = new UpdateKjarMessage(command.getId(), Boolean.TRUE.booleanValue());
                }
                catch (UnsupportedOperationException ex) {
                    logger.info("It isn't possible update a classpath container to a new version");
                }
            } else {
                logger.info("Kjar isn't updatable");
            }
        } else {
            logger.error("KieService is null");
        }
        this.producer.produceSync(this.envConfig.getKieSessionInfosTopicName(), command.getId(), (ResultMessage)msg);
    }

    public void visit(GetKJarGAVCommand command) {
        GetKJarGAVMessage msg = new GetKJarGAVMessage(command.getId(), this.kieSessionContext.getKjarGAVUsed().orElse("KJar GAV NotDefined"));
        this.producer.produceSync(this.envConfig.getKieSessionInfosTopicName(), command.getId(), (ResultMessage)msg);
    }

    public static boolean isEvent(Object obj) {
        Role role = obj.getClass().getAnnotation(Role.class);
        return role != null && role.value() == Role.Type.EVENT;
    }

    public static boolean hasTimestamp(Object obj) {
        return obj.getClass().getAnnotation(Timestamp.class) != null;
    }

    public boolean isFiringUntilHalt() {
        return this.firingUntilHalt;
    }
}

